/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.nativefs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.impl.nativefs.NativeFile;
import dk.apaq.vfs.impl.nativefs.NativeFileSystem;
import dk.apaq.vfs.impl.nativefs.NativeNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeDirectory
extends NativeNode
implements Directory {
    public NativeDirectory(NativeFileSystem fs, java.io.File file) throws FileNotFoundException {
        super(fs, file);
        if (!file.isDirectory()) {
            throw new FileNotFoundException("The fileobject must point at an existing directory.");
        }
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        java.io.File newDir = new java.io.File(this.file, name);
        if (newDir.isFile()) {
            throw new IOException("A file with that name already exists. [uri=" + newDir.toURI() + "]");
        }
        if (newDir.isDirectory()) {
            throw new IOException("A directory with that name already exists. [uri=" + newDir.toURI() + "]");
        }
        boolean created = newDir.mkdir();
        if (!created) {
            throw new IOException("Could not create folder.");
        }
        return new NativeDirectory(this.fs, newDir);
    }

    @Override
    public File createFile(String name) throws IOException {
        java.io.File newFile = new java.io.File(this.file, name);
        boolean created = newFile.createNewFile();
        if (created) {
            return new NativeFile(this.fs, newFile);
        }
        throw new IOException("File already exists. Cannot be created.");
    }

    @Override
    public List<Node> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<File> getFiles() {
        return this.getFiles(null);
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        java.io.File[] files = this.file.listFiles();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (java.io.File file : files) {
            try {
                NativeNode node = file.isDirectory() ? new NativeDirectory(this.fs, file) : new NativeFile(this.fs, file);
                if (filter != null && !filter.accept(node)) continue;
                nodes.add(node);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(NativeDirectory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return nodes;
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        java.io.File[] files = this.file.listFiles();
        ArrayList<Directory> nodes = new ArrayList<Directory>();
        for (java.io.File file : files) {
            if (!file.isDirectory()) continue;
            try {
                NativeDirectory node = new NativeDirectory(this.fs, file);
                if (filter != null && !filter.accept(node)) continue;
                nodes.add(node);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(NativeDirectory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return nodes;
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        java.io.File[] files = this.file.listFiles();
        ArrayList<File> nodes = new ArrayList<File>();
        for (java.io.File file : files) {
            if (file.isDirectory()) continue;
            try {
                NativeFile node = new NativeFile(this.fs, file);
                if (filter != null && !filter.accept(node)) continue;
                nodes.add(node);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(NativeDirectory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return nodes;
    }

    @Override
    public boolean hasChild(String name) {
        java.io.File file = new java.io.File(this.file, name);
        return file.exists();
    }

    @Override
    public boolean hasFile(String name) {
        java.io.File file = new java.io.File(this.file, name);
        return file.isFile();
    }

    @Override
    public boolean hasDirectory(String name) {
        java.io.File file = new java.io.File(this.file, name);
        return file.isDirectory();
    }

    @Override
    public Node getChild(String name) throws FileNotFoundException {
        java.io.File file = new java.io.File(this.file, name);
        if (!file.exists()) {
            throw new FileNotFoundException("The file does not exist. [uri=" + file.toURI() + "]");
        }
        NativeNode node = file.isDirectory() ? new NativeDirectory(this.fs, file) : new NativeFile(this.fs, file);
        return node;
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (node.isDirectory()) {
            throw new FileNotFoundException("The uri is not a file, but a directory. [uri=" + node.toUri() + "]");
        }
        return (File)node;
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        File file;
        try {
            file = this.getFile(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                file = this.createFile(name);
            }
            throw ex;
        }
        return file;
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (!node.isDirectory()) {
            throw new FileNotFoundException("The uri is not a directory, but a file. [uri=" + node.toUri() + "]");
        }
        return (Directory)node;
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        Directory dir;
        try {
            dir = this.getDirectory(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                dir = this.createDirectory(name);
            }
            throw ex;
        }
        return dir;
    }

    @Override
    public boolean isBundle() {
        return this.file.getName().contains(".");
    }
}

