/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.nativefs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.nativefs.NativeDirectory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class NativeFileSystem
implements FileSystem {
    File root;
    HashMap infomap = new HashMap();

    public NativeFileSystem(URI uri) throws IllegalArgumentException {
        this(new File(uri));
    }

    public NativeFileSystem(String path) throws IllegalArgumentException {
        this(new File(path));
    }

    public NativeFileSystem(File file) throws IllegalArgumentException {
        this.infomap.put("FSInfo_Name", "NativeFS");
        this.infomap.put("FSInfo_Description", "A filesystem based upon native files via the java.io package.");
        this.infomap.put("FSInfo_Version", "0.1.0");
        this.infomap.put("FSInfo_HasFreeSpaceInformation", "true");
        this.infomap.put("FSInfo_HasSizeInformation", "true");
        this.root = file;
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IllegalArgumentException("uri must point at a valid directory. [uri=" + this.root.toString() + "]");
        }
    }

    public Map getInfo() {
        return this.infomap;
    }

    public String getName() {
        return "NativeFS(" + this.root.toURI() + ")";
    }

    public Directory getRoot() throws FileNotFoundException {
        return new NativeDirectory(this, this.root);
    }

    public long getSize() {
        return this.root.getTotalSpace();
    }

    public long getFreeSpace() {
        return this.root.getFreeSpace();
    }

    public Node getNode(String path) throws FileNotFoundException {
        Path pathObject = new Path(path);
        Node currentNode = this.getRoot();
        for (int i = 0; i < pathObject.getLevels(); ++i) {
            if (!currentNode.isDirectory()) {
                throw new FileNotFoundException("The path '" + path + "' does not exist.");
            }
            currentNode = currentNode.getChild(pathObject.getLevel(i));
        }
        return currentNode;
    }

    public void close() throws IOException {
    }
}

