/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.nativefs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.nativefs.NativeDirectory;
import dk.apaq.vfs.impl.nativefs.NativeFileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;

public abstract class NativeNode
implements Node {
    protected NativeFileSystem fs;
    protected File file;

    public NativeNode(NativeFileSystem fs, File file) {
        this.fs = fs;
        this.file = file;
    }

    private void deleteNonRecursive(File file) throws IOException {
        boolean deleted = file.delete();
        if (!deleted && file.isDirectory()) {
            throw new IOException("Could not delete directory. Maybe because it is not empty.[path=" + file.toString() + "]");
        }
        if (!deleted) {
            throw new IOException("Could not delete file. [path=" + file.toString() + "]");
        }
    }

    private void deleteRecursive(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("A file cannot be deleted recursively.");
        }
        if (file.exists()) {
            File[] files;
            for (File currentFile : files = file.listFiles()) {
                if (currentFile.isDirectory()) {
                    this.deleteRecursive(currentFile);
                    continue;
                }
                this.deleteNonRecursive(currentFile);
            }
            this.deleteNonRecursive(file);
        }
    }

    public boolean isRoot() {
        try {
            return this.fs.getRoot().equals(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public void delete(boolean recursive) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot delete root folder.");
        }
        if (recursive) {
            this.deleteRecursive(this.file);
        } else {
            this.deleteNonRecursive(this.file);
        }
    }

    public void moveTo(Directory newParent) throws IOException {
        File newParentFile = new File(newParent.toUri());
        File newDestination = new File(newParentFile, this.file.getName());
        boolean moved = this.file.renameTo(newDestination);
        if (!moved) {
            throw new IOException("Could not move the " + (this.file.isDirectory() ? "directory" : "file") + ".");
        }
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        File newParentFile = new File(newParent.toUri());
        File newDestination = new File(newParentFile, newName);
        boolean moved = this.file.renameTo(newDestination);
        if (!moved) {
            throw new IOException("Could not move the " + (this.file.isDirectory() ? "directory" : "file") + ".");
        }
    }

    public void setName(String name) throws IOException {
        File newDestination = new File(this.file.getParentFile(), name);
        boolean moved = this.file.renameTo(newDestination);
        if (!moved) {
            throw new IOException("Could not rename the " + (this.file.isDirectory() ? "directory" : "file") + ".");
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public Directory getParent() throws FileNotFoundException {
        if (this.isRoot()) {
            return null;
        }
        return new NativeDirectory(this.fs, this.file.getParentFile());
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public Date getLastModified() {
        return new Date(this.file.lastModified());
    }

    public void setLastModified(Date date) {
        this.file.setLastModified(date.getTime());
    }

    public int compareTo(Node node) {
        return this.getName().compareTo(node.getName());
    }

    public void delete() throws IOException {
        this.delete(false);
    }

    public URI toUri() {
        return this.file.toURI();
    }

    public int compareTo(Object o) {
        if (o instanceof Node) {
            return this.compareTo((Node)o);
        }
        return 0;
    }

    public boolean equals(Node node) {
        return this.file.equals(((NativeNode)node).file);
    }

    public boolean equals(Object object) {
        if (object instanceof NativeNode) {
            return this.equals((NativeNode)object);
        }
        return false;
    }

    public Path getPath() {
        Path path = new Path();
        Node node = this;
        while (!node.isDirectory() || !((Directory)node).isRoot()) {
            path.addLevel(0, node.getName());
            try {
                node = node.getParent();
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Cannot retrieve parent directory.");
            }
        }
        return path;
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public String getBaseName() {
        String name = this.file.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public String getSuffix() {
        String name = this.file.getName();
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return null;
    }
}

