/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.ram;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.impl.ram.RamFile;
import dk.apaq.vfs.impl.ram.RamNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamDirectory
extends RamNode
implements Directory {
    private final List<RamNode> children = new ArrayList<RamNode>();

    public RamDirectory(RamDirectory parent, String name) {
        super(parent, name);
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        if (this.hasChild(name)) {
            throw new IOException("A child with then name '" + name + "' already exists.");
        }
        RamDirectory file = new RamDirectory(this, name);
        this.children.add(file);
        return file;
    }

    @Override
    public File createFile(String name) throws IOException {
        if (this.hasChild(name)) {
            throw new IOException("A child with then name '" + name + "' already exists.");
        }
        RamFile file = new RamFile(this, name);
        this.children.add(file);
        return file;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public boolean hasChild(String name) {
        try {
            this.getChild(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public boolean hasFile(String name) {
        try {
            this.getFile(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public boolean hasDirectory(String name) {
        try {
            this.getDirectory(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public Node getChild(String name) throws FileNotFoundException {
        for (RamNode node : this.children) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        throw new FileNotFoundException(name + " not found.");
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (!node.isFile()) {
            throw new FileNotFoundException("Node found but was not a file.");
        }
        return (File)node;
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (!node.isDirectory()) {
            throw new FileNotFoundException("Node found but was not a directory.");
        }
        return (Directory)node;
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        try {
            return this.getFile(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                return this.createFile(name);
            }
            throw ex;
        }
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        try {
            return this.getDirectory(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                return this.createDirectory(name);
            }
            throw ex;
        }
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> nodes = new ArrayList<Node>(this.children);
        return nodes;
    }

    protected List<RamNode> getChildrenUnwrapped() {
        return this.children;
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        ArrayList<Directory> nodes = new ArrayList<Directory>();
        for (RamNode node : this.children) {
            if (!node.isDirectory() || filter != null && !filter.accept(node)) continue;
            nodes.add((Directory)((Object)node));
        }
        return nodes;
    }

    @Override
    public List<File> getFiles() {
        ArrayList<File> nodes = new ArrayList<File>();
        for (RamNode node : this.children) {
            if (!node.isFile()) continue;
            nodes.add((File)((Object)node));
        }
        return nodes;
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (RamNode node : this.children) {
            if (filter != null && !filter.accept(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        ArrayList<File> nodes = new ArrayList<File>();
        for (RamNode node : this.children) {
            if (!node.isFile() || filter != null && !filter.accept(node)) continue;
            nodes.add((File)((Object)node));
        }
        return nodes;
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot delete root.");
        }
        if (!recursive && !this.getChildren().isEmpty()) {
            throw new IOException("Cannot delete directory beause it has children and deletion was not recursive.");
        }
        this.parent.getChildrenUnwrapped().remove(this);
    }

    @Override
    public boolean isBundle() {
        return this.getName().contains(".");
    }
}

