/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.ram;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.ram.RamDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RamFilesystem
implements FileSystem {
    RamDirectory root = new RamDirectory(null, "root");
    HashMap infomap = new HashMap();

    public RamFilesystem() {
        this.infomap.put("FSInfo_Name", "RamFS");
        this.infomap.put("FSInfo_Description", "A filesystem based upon objects in ram.");
        this.infomap.put("FSInfo_Version", "0.1.0");
        this.infomap.put("FSInfo_HasFreeSpaceInformation", "false");
        this.infomap.put("FSInfo_HasSizeInformation", "false");
    }

    public Map getInfo() {
        return this.infomap;
    }

    public String getName() {
        return "RamFS";
    }

    public Directory getRoot() throws FileNotFoundException {
        return this.root;
    }

    public long getSize() {
        return -1L;
    }

    public long getFreeSpace() {
        return -1L;
    }

    public Node getNode(String path) throws FileNotFoundException {
        Path pathObject = new Path(path);
        Node currentNode = this.getRoot();
        for (int i = 0; i < pathObject.getLevels(); ++i) {
            if (!currentNode.isDirectory()) {
                throw new FileNotFoundException("The path '" + path + "' does not exist.");
            }
            currentNode = currentNode.getChild(pathObject.getLevel(i));
        }
        return currentNode;
    }

    public void close() throws IOException {
    }
}

