/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.ram;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.ram.RamDirectory;
import dk.apaq.vfs.impl.ram.RamFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;

public class RamNode
implements Node {
    protected RamDirectory parent;
    private String name;
    private Date lastModified = new Date();

    public RamNode(RamDirectory parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public void moveTo(Directory newParent) throws IOException {
        RamDirectory todir = (RamDirectory)newParent;
        this.parent.getChildrenUnwrapped().remove(this);
        todir.getChildrenUnwrapped().add(this);
        this.parent = todir;
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        this.moveTo(newParent);
        this.name = newName;
    }

    public void setName(String name) throws IOException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        if (this.name.contains(".")) {
            return this.name.substring(0, this.name.lastIndexOf("."));
        }
        return this.name;
    }

    public String getSuffix() {
        if (this.name.contains(".")) {
            return this.name.substring(this.name.lastIndexOf(".") + 1);
        }
        return null;
    }

    public Directory getParent() throws FileNotFoundException {
        return this.parent;
    }

    public FileSystem getFileSystem() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isDirectory() {
        return this instanceof RamDirectory;
    }

    public boolean isFile() {
        return this instanceof RamFile;
    }

    public boolean isHidden() {
        return false;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public int compareTo(Node node) {
        return this.getName().compareTo(node.getName());
    }

    public void delete() throws IOException {
        if (this.isDirectory()) {
            ((Directory)((Object)this)).delete(false);
        } else {
            this.parent.getChildrenUnwrapped().remove(this);
        }
    }

    public URI toUri() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Node node) {
        return this == node;
    }

    public Path getPath() {
        Path path = new Path();
        Node node = this;
        while (!node.isDirectory() || !((Directory)node).isRoot()) {
            path.addLevel(0, node.getName());
            try {
                node = node.getParent();
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Cannot retrieve parent directory.");
            }
        }
        return path;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public int compareTo(Object o) {
        return this.compareTo((Node)o);
    }
}

