/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.sftp;

import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.SFTPv3FileHandle;
import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.sftp.SftpFile;
import dk.apaq.vfs.impl.sftp.SftpFileSystem;
import dk.apaq.vfs.impl.sftp.SftpNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpDirectory
extends SftpNode
implements Directory {
    public SftpDirectory(SftpFileSystem fileSystem, Path path, SFTPv3DirectoryEntry entry) throws IOException {
        super(fileSystem, path, entry);
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        this.fileSystem.sftpc.mkdir(name, 1792);
        SFTPv3DirectoryEntry entry = this.resolveChildEntry(name);
        return new SftpDirectory(this.fileSystem, new Path(this.path, name), entry);
    }

    @Override
    public File createFile(String name) throws IOException {
        SFTPv3FileHandle fh = this.fileSystem.sftpc.createFile(name);
        this.fileSystem.sftpc.closeFile(fh);
        SFTPv3DirectoryEntry entry = this.resolveChildEntry(name);
        return new SftpFile(this.fileSystem, new Path(this.path, name), entry);
    }

    @Override
    public boolean hasChild(String name) {
        try {
            this.getChild(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public boolean hasFile(String name) {
        try {
            this.getFile(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public boolean hasDirectory(String name) {
        try {
            this.getDirectory(name);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public Node getChild(final String name) throws FileNotFoundException {
        try {
            List<Node> nodes = this.getChildren(new NodeFilter(){

                public boolean accept(Node node) {
                    return name.equals(node.getName());
                }
            });
            if (nodes.isEmpty()) {
                throw new FileNotFoundException("Unable to find node.[name=" + name + "]");
            }
            return nodes.get(0);
        }
        catch (IOException ex) {
            throw new FileNotFoundException(ex.getMessage() + " (path=" + new Path(this.path, name) + ")");
        }
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (!node.isFile()) {
            throw new FileNotFoundException("Node found but it was not a file.");
        }
        return (File)node;
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        Node node = this.getChild(name);
        if (!node.isDirectory()) {
            throw new FileNotFoundException("Node found but it was not a directory.");
        }
        return (Directory)node;
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        File file;
        try {
            file = this.getFile(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                file = this.createFile(name);
            }
            throw ex;
        }
        return file;
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        Directory dir;
        try {
            dir = this.getDirectory(name);
        }
        catch (FileNotFoundException ex) {
            if (createIfNeeded) {
                dir = this.createDirectory(name);
            }
            throw ex;
        }
        return dir;
    }

    @Override
    public List<Node> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<File> getFiles() {
        return this.getFiles(null);
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            Vector entries = this.fileSystem.sftpc.ls(this.path.toString());
            for (SFTPv3DirectoryEntry entry : entries) {
                SftpNode node = null;
                Path childPath = this.path.clone();
                childPath.addLevel(entry.filename);
                if (entry.attributes.isDirectory()) {
                    node = new SftpDirectory(this.fileSystem, childPath, entry);
                }
                if (entry.attributes.isRegularFile()) {
                    node = new SftpFile(this.fileSystem, childPath, entry);
                }
                if (filter != null && !filter.accept(node)) continue;
                nodes.add(node);
            }
            return nodes;
        }
        catch (IOException ex) {
            return nodes;
        }
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        ArrayList<Directory> nodes = new ArrayList<Directory>();
        try {
            Vector entries = this.fileSystem.sftpc.ls(this.path.toString());
            for (SFTPv3DirectoryEntry entry : entries) {
                Path childPath = this.path.clone();
                childPath.addLevel(entry.filename);
                if (entry.attributes.isRegularFile()) continue;
                SftpDirectory dir = new SftpDirectory(this.fileSystem, childPath, entry);
                if (filter != null && !filter.accept(dir)) continue;
                nodes.add(dir);
            }
            return nodes;
        }
        catch (IOException ex) {
            return nodes;
        }
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        ArrayList<File> nodes = new ArrayList<File>();
        try {
            Vector entries = this.fileSystem.sftpc.ls(this.path.toString());
            for (SFTPv3DirectoryEntry entry : entries) {
                Path childPath = this.path.clone();
                childPath.addLevel(entry.filename);
                if (entry.attributes.isDirectory()) continue;
                SftpFile file = new SftpFile(this.fileSystem, childPath, entry);
                if (filter != null && !filter.accept(file)) continue;
                nodes.add(file);
            }
            return nodes;
        }
        catch (IOException ex) {
            return nodes;
        }
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        this.fileSystem.sftpc.rmdir(this.path.toString());
    }

    @Override
    public boolean isBundle() {
        return this.getName().contains(".");
    }
}

