/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.sftp;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.SFTPv3Client;
import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.sftp.SftpDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SftpFileSystem
implements FileSystem {
    private HashMap infomap = new HashMap();
    protected SFTPv3Client sftpc = null;

    public SftpFileSystem(String host, int port, String user, String password) throws IOException {
        this(host, port, user, password, 60000);
    }

    public SftpFileSystem(String host, int port, String user, String password, int timeout) throws IOException {
        this.infomap.put("FSInfo_Name", "SftpFS");
        this.infomap.put("FSInfo_Description", "A filesystem based upon Sftp.");
        this.infomap.put("FSInfo_Version", "0.1.0");
        this.infomap.put("FSInfo_HasFreeSpaceInformation", "false");
        this.infomap.put("FSInfo_HasSizeInformation", "false");
        Connection sshcon = new Connection(host, port);
        ConnectionInfo ci = sshcon.connect(null, timeout, timeout);
        if (!sshcon.authenticateWithPassword(user, password)) {
            sshcon.close();
            throw new IOException("Unable to authenticate.");
        }
        this.sftpc = new SFTPv3Client(sshcon);
    }

    public String getName() {
        return "SftpFileSystem";
    }

    public Map getInfo() {
        return this.infomap;
    }

    public Directory getRoot() throws FileNotFoundException {
        try {
            return new SftpDirectory(this, new Path(), null);
        }
        catch (IOException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    public long getSize() {
        return 0L;
    }

    public long getFreeSpace() {
        return 0L;
    }

    public Node getNode(String path) throws FileNotFoundException {
        Path pathObject = new Path(path);
        Node currentNode = this.getRoot();
        for (int i = 0; i < pathObject.getLevels(); ++i) {
            if (!currentNode.isDirectory()) {
                throw new FileNotFoundException("The path '" + path + "' does not exist.");
            }
            currentNode = currentNode.getChild(pathObject.getLevel(i));
        }
        return currentNode;
    }

    public void close() throws IOException {
        this.sftpc.close();
    }
}

