/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.sftp;

import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.SFTPv3FileHandle;
import java.io.IOException;
import java.io.InputStream;

public class SftpInputStream
extends InputStream {
    private SFTPv3Client sftpc;
    private SFTPv3DirectoryEntry entry;
    private SFTPv3FileHandle fileHandle;
    private long offset = 0L;

    public SftpInputStream(SFTPv3Client sftpc, SFTPv3DirectoryEntry entry, SFTPv3FileHandle fileHandle) {
        this.sftpc = sftpc;
        this.fileHandle = fileHandle;
        this.entry = entry;
    }

    public int available() throws IOException {
        long avail = this.entry.attributes.size - this.offset;
        if (avail > 32768L) {
            avail = 32768L;
        }
        return (int)avail;
    }

    public int read() throws IOException {
        byte[] bytes = new byte[]{};
        this.sftpc.read(this.fileHandle, this.offset, bytes, 0, 1);
        ++this.offset;
        return bytes[0];
    }

    public void close() throws IOException {
        this.sftpc.closeFile(this.fileHandle);
        super.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.sftpc.read(this.fileHandle, this.offset, b, off, len);
        if (bytesRead > 0) {
            this.offset += (long)bytesRead;
        }
        return bytesRead;
    }

    public int read(byte[] b) throws IOException {
        return super.read(b);
    }
}

