/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.sftp;

import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.sftp.SftpDirectory;
import dk.apaq.vfs.impl.sftp.SftpFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Vector;

public class SftpNode
implements Node {
    protected SftpFileSystem fileSystem;
    protected Path path;
    protected SFTPv3DirectoryEntry entry;

    public SftpNode(SftpFileSystem fileSystem, Path path, SFTPv3DirectoryEntry entry) throws IOException {
        this.fileSystem = fileSystem;
        this.path = path;
        this.entry = entry;
    }

    protected SFTPv3DirectoryEntry resolveChildEntry(String name) throws IOException {
        Path childPath = new Path(this.path, name);
        Vector entries = this.fileSystem.sftpc.ls(childPath.toString());
        if (entries.isEmpty()) {
            throw new FileNotFoundException("Unable to resolve child.");
        }
        return (SFTPv3DirectoryEntry)entries.elementAt(0);
    }

    public void moveTo(Directory newParent) throws IOException {
        this.moveTo(newParent, this.getName());
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        this.fileSystem.sftpc.mv(this.path.toString(), new Path(newParent.getPath(), newName).toString());
    }

    public void setName(String name) throws IOException {
        Path parentPath = this.path.clone();
        parentPath.removeLevel(parentPath.getLevels() - 1);
        this.fileSystem.sftpc.mv(this.path.toString(), new Path(parentPath, name).toString());
    }

    public String getName() {
        return this.path.getLevels() == 0 ? "" : this.path.getLeaf();
    }

    public String getBaseName() {
        String name = this.getName();
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public String getSuffix() {
        String name = this.getName();
        if (name.contains(".")) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return null;
    }

    public Directory getParent() throws FileNotFoundException {
        if (this.path.getLevels() == 0) {
            return null;
        }
        try {
            Path parentPath = this.path.clone();
            parentPath.removeLevel(this.path.getLevels() - 1);
            return new SftpDirectory(this.fileSystem, parentPath, null);
        }
        catch (IOException ex) {
            throw new FileNotFoundException("Unable to get parent. " + ex.getMessage());
        }
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean isRoot() {
        return this.path.getLevels() == 0;
    }

    public boolean isDirectory() {
        return this.isRoot() ? true : this.entry.attributes.isDirectory();
    }

    public boolean isFile() {
        return this.isRoot() ? false : this.entry.attributes.isRegularFile();
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public Date getLastModified() {
        return this.isRoot() ? new Date(0L) : new Date(this.entry.attributes.mtime.intValue());
    }

    public void setLastModified(Date date) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareTo(Node node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void delete() throws IOException {
        this.fileSystem.sftpc.rm(this.path.toString());
    }

    public URI toUri() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean equals(Node node) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Path getPath() {
        return this.path;
    }

    public boolean canRead() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canWrite() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

