/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.subfs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.File;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.NodeFilter;
import dk.apaq.vfs.impl.subfs.SubFile;
import dk.apaq.vfs.impl.subfs.SubNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubDirectory
extends SubNode
implements Directory {
    private Directory subbedDirectory;

    public SubDirectory(FileSystem fs, SubDirectory parent, Directory subbedDirectory) {
        super(fs, parent, subbedDirectory);
        this.subbedDirectory = subbedDirectory;
    }

    @Override
    public Directory createDirectory(String name) throws IOException {
        return new SubDirectory(this.fs, this, this.subbedDirectory.createDirectory(name));
    }

    @Override
    public File createFile(String name) throws IOException {
        return new SubFile(this.fs, this, this.subbedDirectory.createFile(name));
    }

    @Override
    public boolean isRoot() {
        try {
            return this.getParent() == null;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    @Override
    public boolean hasChild(String name) {
        return this.subbedDirectory.hasChild(name);
    }

    @Override
    public boolean hasFile(String name) {
        return this.subbedDirectory.hasFile(name);
    }

    @Override
    public boolean hasDirectory(String name) {
        return this.subbedDirectory.hasDirectory(name);
    }

    @Override
    public Node getChild(String name) throws FileNotFoundException {
        Node node = this.subbedDirectory.getChild(name);
        if (node.isDirectory()) {
            return new SubDirectory(this.fs, this, (Directory)node);
        }
        return new SubFile(this.fs, this, (File)node);
    }

    @Override
    public File getFile(String name) throws FileNotFoundException {
        return new SubFile(this.fs, this, this.subbedDirectory.getFile(name));
    }

    @Override
    public Directory getDirectory(String name) throws FileNotFoundException {
        return new SubDirectory(this.fs, this, this.subbedDirectory.getDirectory(name));
    }

    @Override
    public File getFile(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        return new SubFile(this.fs, this, this.subbedDirectory.getFile(name, createIfNeeded));
    }

    @Override
    public Directory getDirectory(String name, boolean createIfNeeded) throws FileNotFoundException, IOException {
        return new SubDirectory(this.fs, this, this.subbedDirectory.getDirectory(name, createIfNeeded));
    }

    @Override
    public List<Node> getChildren() {
        return this.getChildren(null);
    }

    @Override
    public List<Directory> getDirectories() {
        return this.getDirectories(null);
    }

    @Override
    public List<File> getFiles() {
        return this.getFiles(null);
    }

    @Override
    public List<Node> getChildren(NodeFilter filter) {
        List<Node> childList = this.subbedDirectory.getChildren(filter);
        ArrayList<Node> subbedList = new ArrayList<Node>();
        for (Node node : childList) {
            subbedList.add(node.isDirectory() ? new SubDirectory(this.fs, this, (Directory)node) : new SubFile(this.fs, this, (File)node));
        }
        return subbedList;
    }

    @Override
    public List<Directory> getDirectories(NodeFilter filter) {
        List<Directory> childList = this.subbedDirectory.getDirectories(filter);
        ArrayList<Directory> subbedList = new ArrayList<Directory>();
        for (Directory node : childList) {
            subbedList.add(new SubDirectory(this.fs, this, node));
        }
        return subbedList;
    }

    @Override
    public List<File> getFiles(NodeFilter filter) {
        List<File> childList = this.subbedDirectory.getFiles(filter);
        ArrayList<File> subbedList = new ArrayList<File>();
        for (File node : childList) {
            subbedList.add(new SubFile(this.fs, this, node));
        }
        return subbedList;
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        if (this.isRoot()) {
            throw new IOException("Cannot delete root.");
        }
        this.subbedDirectory.delete(recursive);
    }

    @Override
    public boolean isBundle() {
        return this.subbedDirectory.isBundle();
    }
}

