/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.subfs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.subfs.SubDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class SubFs
implements FileSystem {
    private Directory root;
    private FileSystem fs;

    public SubFs(FileSystem fs, Directory root) {
        this.fs = fs;
        this.root = new SubDirectory((FileSystem)this, null, root);
    }

    public String getName() {
        return this.fs.getName();
    }

    public Map getInfo() {
        return this.fs.getInfo();
    }

    public Directory getRoot() throws FileNotFoundException {
        return this.root;
    }

    public long getSize() {
        return this.fs.getSize();
    }

    public long getFreeSpace() {
        return this.fs.getFreeSpace();
    }

    public Node getNode(String path) throws FileNotFoundException {
        Path pathObject = new Path(path);
        Node currentNode = this.root;
        for (int i = 0; i < pathObject.getLevels(); ++i) {
            if (!currentNode.isDirectory()) {
                throw new FileNotFoundException("The path '" + path + "' does not exist.");
            }
            currentNode = currentNode.getChild(pathObject.getLevel(i));
        }
        return currentNode;
    }

    public void close() throws IOException {
        this.fs.close();
    }
}

