/*
 * Decompiled with CFR 0.152.
 */
package dk.apaq.vfs.impl.subfs;

import dk.apaq.vfs.Directory;
import dk.apaq.vfs.FileSystem;
import dk.apaq.vfs.Node;
import dk.apaq.vfs.Path;
import dk.apaq.vfs.impl.subfs.SubDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Date;

public class SubNode
implements Node {
    protected FileSystem fs;
    private Node subbedNode;
    private SubDirectory parent;

    public SubNode(FileSystem fs, SubDirectory parent, Node subbedNode) {
        this.fs = fs;
        this.subbedNode = subbedNode;
        this.parent = parent;
    }

    public void moveTo(Directory newParent) throws IOException {
        this.subbedNode.moveTo(newParent);
    }

    public void moveTo(Directory newParent, String newName) throws IOException {
        this.subbedNode.moveTo(newParent, newName);
    }

    public void setName(String name) throws IOException {
        this.subbedNode.setName(name);
    }

    public String getName() {
        return this.subbedNode.getName();
    }

    public String getBaseName() {
        return this.subbedNode.getBaseName();
    }

    public String getSuffix() {
        return this.subbedNode.getSuffix();
    }

    public Directory getParent() throws FileNotFoundException {
        return this.parent;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public boolean isDirectory() {
        return this.subbedNode.isDirectory();
    }

    public boolean isFile() {
        return this.subbedNode.isFile();
    }

    public boolean isHidden() {
        return this.subbedNode.isHidden();
    }

    public Date getLastModified() {
        return this.subbedNode.getLastModified();
    }

    public void setLastModified(Date date) {
        this.subbedNode.setLastModified(date);
    }

    public int compareTo(Node node) {
        return this.subbedNode.compareTo(node);
    }

    public void delete() throws IOException {
        if (this instanceof SubDirectory && ((SubDirectory)this).isRoot()) {
            throw new IOException("Cannot delete root.");
        }
        this.subbedNode.delete();
    }

    public URI toUri() {
        return this.subbedNode.toUri();
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            return this.equals((Node)o);
        }
        return super.equals(o);
    }

    public boolean equals(Node node) {
        return this.subbedNode.equals(((SubNode)node).subbedNode);
    }

    public Path getPath() {
        Path path = new Path();
        Node node = this;
        while (!node.isDirectory() || !((Directory)node).isRoot()) {
            path.addLevel(0, node.getName());
            try {
                node = node.getParent();
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Cannot retrieve parent directory.");
            }
        }
        return path;
    }

    public boolean canRead() {
        return this.subbedNode.canRead();
    }

    public boolean canWrite() {
        return this.subbedNode.canWrite();
    }

    public int compareTo(Object o) {
        return this.subbedNode.compareTo(o);
    }
}

