/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.audit;

import dk.gov.oio.saml.audit.AuditLogger;
import dk.gov.oio.saml.audit.Slf4JAuditLogger;
import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditService {
    private static final Logger log = LoggerFactory.getLogger(AuditService.class);
    private static SimpleDateFormat JSON_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private transient AuditLogger auditLogger;
    private transient Configuration configuration;

    public AuditService(Configuration configuration) throws InitializationException {
        log.debug("Initialize AuditService");
        this.configuration = configuration;
        this.auditLogger = this.createAuditLogger(configuration.getAuditLoggerClassName());
    }

    public void auditLog(Builder auditBuilder) {
        if (null != auditBuilder) {
            this.auditLogger.auditLog(auditBuilder.withAuthnAttribute("Time", JSON_DATE_FORMATTER.format(Calendar.getInstance().getTime())).withAuthnAttribute("SpEntityID", this.configuration.getSpEntityID()).withAuthnAttribute("IdpEntityID", this.configuration.getIdpEntityID()).toJSON());
        }
    }

    private AuditLogger createAuditLogger(String auditLoggerClassName) throws InitializationException {
        Class adapterClazz = Slf4JAuditLogger.class;
        try {
            if (StringUtil.isNotEmpty(auditLoggerClassName)) {
                log.info("Initializing AuditLogger '{}'", (Object)auditLoggerClassName);
                adapterClazz = Class.forName(auditLoggerClassName);
            }
            for (Constructor<?> constructor : adapterClazz.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                log.info("Create '{}' AuditLogger", (Object)adapterClazz.getName());
                return (AuditLogger)constructor.newInstance(new Object[0]);
            }
            throw new InitializationException(String.format("Cannot create AuditLogger, '%s' must have default constructor", adapterClazz.getName()));
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error("Failed creating AuditLogger", (Throwable)e);
            throw new InitializationException(String.format("Cannot create AuditLogger, '%s' must have default constructor and implement 'dk.gov.oio.saml.audit.AuditLogger'", adapterClazz.getName()), (Throwable)e);
        }
    }

    public static class Builder {
        private Map<String, String> auditMap = new LinkedHashMap<String, String>();

        public Builder withAuthnAttribute(String key, String value) {
            this.auditMap.putIfAbsent(key, value);
            return this;
        }

        public String toJSON() {
            return StringUtil.map2json(this.auditMap);
        }
    }
}

