/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.filter;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.service.AuthnRequestService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.AssertionWrapper;
import dk.gov.oio.saml.session.AssertionWrapperHolder;
import dk.gov.oio.saml.session.AuthnRequestWrapper;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.util.AuditRequestUtil;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import dk.gov.oio.saml.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedFilter.class);
    private boolean isPassive;
    private boolean forceAuthn;
    private String attributeProfile;
    private NSISLevel requiredNsisLevel = NSISLevel.NONE;

    public void init(FilterConfig filterConfig) throws ServletException {
        HashMap<String, String> config = this.getConfig(filterConfig);
        String isPassiveStr = config.get("oiosaml.filter.ispassive.enabled");
        String isForceAuthnStr = config.get("oiosaml.filter.forceauthn.enabled");
        this.isPassive = isPassiveStr != null ? Boolean.parseBoolean(isPassiveStr) : false;
        boolean bl = this.forceAuthn = isForceAuthnStr != null ? Boolean.parseBoolean(isForceAuthnStr) : false;
        if (this.isPassive && this.forceAuthn) {
            log.warn("IsPassive and forceAuthn Cannot both be true");
        }
        try {
            String requiredLevelString = config.get("oiosaml.filter.nsis.required");
            if (requiredLevelString != null) {
                this.requiredNsisLevel = NSISLevel.valueOf(requiredLevelString);
            }
        }
        catch (Exception ex) {
            log.warn("Unknown required NSIS level in configuration: " + (Object)((Object)this.requiredNsisLevel));
        }
        this.attributeProfile = config.get("oiosaml.filter.attribute.profile");
        if (this.attributeProfile != null && !"https://data.gov.dk/eid/Person".equals(this.attributeProfile) && !"https://data.gov.dk/eid/Professional".equals(this.attributeProfile)) {
            log.warn("AttributeProfile should be either null, https://data.gov.dk/eid/Person or https://data.gov.dk/eid/Professional");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block7: {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            log.debug("AuthenticatedFilter invoked by endpoint: '{}{}'", (Object)req.getContextPath(), (Object)req.getServletPath());
            try {
                OIOSAML3Service.getSessionCleanerService().startCleanerIfMissing(req.getSession());
                SessionHandler sessionHandler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
                AssertionWrapper assertionWrapper = sessionHandler.getAssertion(req.getSession());
                if (this.userNeedsAuthentication(req, sessionHandler, assertionWrapper)) {
                    log.debug("Filter config: isPassive: {}, forceAuthn: {}", (Object)this.isPassive, (Object)this.forceAuthn);
                    AuthnRequestService authnRequestService = AuthnRequestService.getInstance();
                    String requestPath = req.getRequestURI();
                    if (req.getQueryString() != null) {
                        requestPath = requestPath + "?" + req.getQueryString();
                    }
                    MessageContext<SAMLObject> authnRequest = authnRequestService.createMessageWithAuthnRequest(this.isPassive, this.forceAuthn, this.requiredNsisLevel, this.attributeProfile);
                    OIOSAML3Service.getAuditService().auditLog(AuditRequestUtil.createBasicAuditBuilder(req, "BSA1", "AuthnRequest").withAuthnAttribute("AUTHN_REQUEST_ID", ((AuthnRequest)authnRequest.getMessage()).getID()).withAuthnAttribute("URL", requestPath));
                    this.sendAuthnRequest(req, res, authnRequest, this.requiredNsisLevel, requestPath);
                    break block7;
                }
                try {
                    this.putAssertionOnThreadLocal(req.getSession());
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                }
                finally {
                    this.removeAssertionFromThreadLocal();
                }
            }
            catch (Exception e) {
                log.warn("Unexpected error in authentication filter", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void destroy() {
        OIOSAML3Service.getSessionCleanerService().stopCleaner();
        OIOSAML3Service.getSessionHandlerFactory().close();
    }

    private boolean userNeedsAuthentication(HttpServletRequest req, SessionHandler sessionHandler, AssertionWrapper assertionWrapper) {
        if (null == assertionWrapper || !sessionHandler.isAuthenticated(req.getSession())) {
            log.debug("Unauthenticated session, Required NSIS Level: {}", (Object)this.requiredNsisLevel);
            return true;
        }
        if (!this.isAssuranceSufficient(this.requiredNsisLevel, assertionWrapper.getNsisLevel(), assertionWrapper.getAssuranceLevel())) {
            log.debug("Current NSIS Level on session: {}, Required NSIS Level: {}", (Object)assertionWrapper.getNsisLevel(), (Object)this.requiredNsisLevel);
            return true;
        }
        log.debug("Authenticated session, NSIS Level: {}", (Object)this.requiredNsisLevel);
        return false;
    }

    private boolean isAssuranceSufficient(NSISLevel requiredNsisLevel, NSISLevel authenticatedNsisLevel, String authenticatedAssuranceLevel) {
        Configuration configuration = OIOSAML3Service.getConfig();
        if (configuration.isAssuranceLevelAllowed() && authenticatedAssuranceLevel != null) {
            Integer i;
            try {
                i = Integer.parseInt(authenticatedAssuranceLevel);
            }
            catch (Exception ex) {
                return false;
            }
            return requiredNsisLevel.getAssuranceLevel() <= i;
        }
        return requiredNsisLevel.equalOrLesser(authenticatedNsisLevel);
    }

    private void removeAssertionFromThreadLocal() {
        AssertionWrapperHolder.clear();
    }

    private void putAssertionOnThreadLocal(HttpSession session) throws InternalException {
        SessionHandler sessionHandler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
        AssertionWrapper assertion = sessionHandler.getAssertion(session);
        if (assertion != null) {
            AssertionWrapperHolder.set(assertion);
            if (log.isDebugEnabled()) {
                log.debug("Saved Wrapped Assertion to ThreadLocal");
            }
        } else {
            log.warn("No assertion available on session");
        }
    }

    private void sendAuthnRequest(HttpServletRequest req, HttpServletResponse res, MessageContext<SAMLObject> authnRequest, NSISLevel requestedNsisLevel, String requestPath) throws InternalException {
        try {
            log.debug("AuthnRequest: {}", (Object)StringUtil.elementToString(SamlHelper.marshallObject((XMLObject)authnRequest.getMessage())));
        }
        catch (MarshallingException e) {
            log.warn("Could not marshall AuthnRequest for logging purposes");
        }
        SessionHandler sessionHandler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
        AuthnRequestWrapper wrapper = new AuthnRequestWrapper((AuthnRequest)authnRequest.getMessage(), this.requiredNsisLevel, requestPath);
        sessionHandler.storeAuthnRequest(req.getSession(), wrapper);
        log.info("Outgoing AuthnRequest - ID:'{}' Issuer:'{}' IssueInstant:'{}' Destination:'{}'", new Object[]{wrapper.getId(), wrapper.getIssuer(), wrapper.getIssueInstant(), wrapper.getDestination()});
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(authnRequest);
        encoder.setHttpServletResponse(res);
        try {
            OIOSAML3Service.getAuditService().auditLog(AuditRequestUtil.createBasicAuditBuilder(req, "BSA2", "SendAuthnRequest").withAuthnAttribute("AUTHN_REQUEST_ID", ((AuthnRequest)authnRequest.getMessage()).getID()));
            encoder.initialize();
            encoder.encode();
        }
        catch (ComponentInitializationException | MessageEncodingException e) {
            throw new InternalException("Failed sending AuthnRequest", (Exception)e);
        }
    }

    private HashMap<String, String> getConfig(FilterConfig filterConfig) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        Enumeration keys = filterConfig.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = filterConfig.getInitParameter(key);
            configMap.put(key, value);
        }
        return configMap;
    }
}

