/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.filter;

import dk.gov.oio.saml.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SameSiteFilter
implements Filter {
    private static final String SAMESITE_COOKIE_HEADER = "Set-Cookie";
    private static final String SAMESITE_ATTRIBITE_NAME = "SameSite";
    private static final String SAMESITE_NONE_VALUE = "None";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            chain.doFilter(request, (ServletResponse)new SameSiteWrapper((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    private class SameSiteWrapper
    extends HttpServletResponseWrapper {
        private HttpServletResponse response;

        public SameSiteWrapper(HttpServletResponse resp) {
            super(resp);
            this.response = resp;
        }

        public void sendError(int sc) throws IOException {
            this.fixSameSiteCookies();
            super.sendError(sc);
        }

        public PrintWriter getWriter() throws IOException {
            this.fixSameSiteCookies();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.fixSameSiteCookies();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.fixSameSiteCookies();
            super.sendRedirect(location);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.fixSameSiteCookies();
            return super.getOutputStream();
        }

        private void fixSameSiteCookies() {
            Collection headers = this.response.getHeaders(SameSiteFilter.SAMESITE_COOKIE_HEADER);
            if (headers == null || headers.size() == 0) {
                return;
            }
            boolean firstCookie = true;
            for (String header : headers) {
                if (StringUtil.isEmpty(header)) continue;
                if (!header.contains(SameSiteFilter.SAMESITE_ATTRIBITE_NAME)) {
                    header = header + ";" + SameSiteFilter.SAMESITE_ATTRIBITE_NAME + "=" + SameSiteFilter.SAMESITE_NONE_VALUE;
                }
                if (firstCookie) {
                    this.response.setHeader(SameSiteFilter.SAMESITE_COOKIE_HEADER, header);
                } else {
                    this.response.addHeader(SameSiteFilter.SAMESITE_COOKIE_HEADER, header);
                }
                firstCookie = false;
            }
        }
    }
}

