/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.model;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.service.CRLChecker;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.ResourceUtil;
import java.io.ByteArrayInputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdPMetadata {
    private static final Logger log = LoggerFactory.getLogger(IdPMetadata.class);
    private List<java.security.cert.X509Certificate> validEncryptionCertificates = new ArrayList<java.security.cert.X509Certificate>();
    private List<java.security.cert.X509Certificate> validSigningCertificates = new ArrayList<java.security.cert.X509Certificate>();
    private List<java.security.cert.X509Certificate> validUnspecifiedCertificates = new ArrayList<java.security.cert.X509Certificate>();
    private String metadataFilePath;
    private AbstractReloadingMetadataResolver resolver;
    private DateTime lastCRLCheck;
    private String entityId;
    private String metadataURL;

    public IdPMetadata(String entityId, String metadataURL, String metadataFilePath) throws ExternalException, InternalException {
        this.entityId = entityId;
        this.metadataURL = metadataURL;
        this.metadataFilePath = metadataFilePath;
        this.getEntityDescriptor();
    }

    public EntityDescriptor getEntityDescriptor() throws InternalException, ExternalException {
        this.initMetadataResolver();
        if (!this.resolver.wasLastRefreshSuccess().booleanValue()) {
            log.debug("Last Metadata was not successful, Refreshing metadata.");
            try {
                this.resolver.refresh();
            }
            catch (ResolverException e) {
                throw new ExternalException("Could not get Metadata from url", (Exception)((Object)e));
            }
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIdCriterion(this.entityId));
        try {
            EntityDescriptor entityDescriptor = this.resolver.resolveSingle(criteriaSet);
            return entityDescriptor;
        }
        catch (ResolverException e) {
            throw new InternalException("Configured entityID not found in metadata", (Exception)((Object)e));
        }
    }

    public IDPSSODescriptor getSSODescriptor() throws ExternalException, InternalException {
        return this.getEntityDescriptor().getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public java.security.cert.X509Certificate getValidX509Certificate(UsageType usageType) throws InternalException, ExternalException {
        this.doRevocationCheck();
        java.security.cert.X509Certificate result = null;
        if (UsageType.ENCRYPTION.equals((Object)usageType)) {
            if (this.validEncryptionCertificates != null && !this.validEncryptionCertificates.isEmpty()) {
                result = this.validEncryptionCertificates.get(0);
            }
        } else if (UsageType.SIGNING.equals((Object)usageType) && this.validSigningCertificates != null && !this.validSigningCertificates.isEmpty()) {
            result = this.validSigningCertificates.get(0);
        }
        if (result == null && this.validUnspecifiedCertificates != null && !this.validUnspecifiedCertificates.isEmpty()) {
            result = this.validUnspecifiedCertificates.get(0);
        }
        return result;
    }

    private List<java.security.cert.X509Certificate> getAllX509CertificatesWithUsageType(UsageType usageType) throws InternalException, ExternalException {
        ArrayList<java.security.cert.X509Certificate> certificates = new ArrayList<java.security.cert.X509Certificate>();
        X509Certificate x509Certificate = null;
        IDPSSODescriptor ssoDescriptor = this.getSSODescriptor();
        for (KeyDescriptor keyDescriptor : ssoDescriptor.getKeyDescriptors()) {
            if (!Objects.equals(usageType, keyDescriptor.getUse()) || (x509Certificate = (X509Certificate)((X509Data)keyDescriptor.getKeyInfo().getX509Datas().get(0)).getX509Certificates().get(0)) == null) continue;
            byte[] bytes = Base64.decode((String)x509Certificate.getValue());
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            CertificateFactory instance = null;
            try {
                instance = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException e) {
                throw new InternalException("Could not create factory to parse X509 Certificate", e);
            }
            try {
                certificates.add((java.security.cert.X509Certificate)instance.generateCertificate(inputStream));
            }
            catch (CertificateException e) {
                throw new ExternalException("Could not parse X509 Certificate from Metadata", e);
            }
        }
        return certificates;
    }

    public SingleLogoutService getLogoutEndpoint() throws ExternalException, InternalException {
        IDPSSODescriptor ssoDescriptor = this.getSSODescriptor();
        for (SingleLogoutService singleLogoutService : ssoDescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService;
        }
        throw new ExternalException("Could not find SLO endpoint for Redirect binding in metadata");
    }

    public String getLogoutResponseEndpoint() throws InternalException, ExternalException {
        IDPSSODescriptor idpssoDescriptor = this.getSSODescriptor();
        for (SingleLogoutService singleLogoutService : idpssoDescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(singleLogoutService.getBinding())) continue;
            String responseLocation = singleLogoutService.getResponseLocation();
            if (responseLocation != null && !responseLocation.isEmpty()) {
                return responseLocation;
            }
            return singleLogoutService.getLocation();
        }
        throw new ExternalException("Unable to find SingleLogoutService with binding HTTPRedirect and an ResponseLocation");
    }

    public DateTime getLastCRLCheck() {
        return this.lastCRLCheck;
    }

    private void doRevocationCheck() throws ExternalException, InternalException {
        Configuration config = OIOSAML3Service.getConfig();
        if (config.isCRLCheckEnabled() || config.isOcspCheckEnabled()) {
            DateTime lastUpdate = this.resolver.getLastUpdate();
            if (this.lastCRLCheck == null || lastUpdate != null && lastUpdate.isAfter((ReadableInstant)this.lastCRLCheck)) {
                try {
                    Set<java.security.cert.X509Certificate> validEncryptionCertificates = CRLChecker.checkCertificates(this.getAllX509CertificatesWithUsageType(UsageType.ENCRYPTION), this.getLastCRLCheck());
                    this.validEncryptionCertificates.clear();
                    if (validEncryptionCertificates != null) {
                        this.validEncryptionCertificates.addAll(validEncryptionCertificates);
                    }
                    Set<java.security.cert.X509Certificate> validSigningCertificates = CRLChecker.checkCertificates(this.getAllX509CertificatesWithUsageType(UsageType.SIGNING), this.getLastCRLCheck());
                    this.validSigningCertificates.clear();
                    if (validSigningCertificates != null) {
                        this.validSigningCertificates.addAll(validSigningCertificates);
                    }
                    Set<java.security.cert.X509Certificate> validUnspecifiedCertificates = CRLChecker.checkCertificates(this.getAllX509CertificatesWithUsageType(UsageType.UNSPECIFIED), this.getLastCRLCheck());
                    Set<java.security.cert.X509Certificate> validNullCertificates = CRLChecker.checkCertificates(this.getAllX509CertificatesWithUsageType(null), this.getLastCRLCheck());
                    this.validUnspecifiedCertificates.clear();
                    if (validUnspecifiedCertificates != null) {
                        this.validUnspecifiedCertificates.addAll(validUnspecifiedCertificates);
                    }
                    if (validNullCertificates != null) {
                        this.validUnspecifiedCertificates.addAll(validNullCertificates);
                    }
                    this.lastCRLCheck = DateTime.now();
                }
                catch (ExternalException | InternalException | InitializationException e) {
                    log.warn("CRL check failed", e);
                    return;
                }
            }
        } else {
            this.validEncryptionCertificates = this.getAllX509CertificatesWithUsageType(UsageType.ENCRYPTION);
            this.validSigningCertificates = this.getAllX509CertificatesWithUsageType(UsageType.SIGNING);
            List<java.security.cert.X509Certificate> validUnspecified = this.getAllX509CertificatesWithUsageType(UsageType.UNSPECIFIED);
            validUnspecified.addAll(this.getAllX509CertificatesWithUsageType(null));
            this.validUnspecifiedCertificates = validUnspecified;
        }
    }

    private void initMetadataResolver() throws InternalException, ExternalException {
        if (this.resolver == null || !this.resolver.isInitialized()) {
            try {
                CloseableHttpClient httpClient;
                Configuration config = OIOSAML3Service.getConfig();
                if (config.isSupportSelfSigned()) {
                    TrustSelfSignedStrategy acceptingTrustStrategy = new TrustSelfSignedStrategy();
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
                    SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                    httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
                } else {
                    httpClient = HttpClients.createDefault();
                }
                if (this.metadataFilePath != null) {
                    log.debug("MetadataFilePath supplied. Using file based metadata resolver");
                    this.resolver = new FilesystemMetadataResolver(ResourceUtil.getResourceAsFile(this.metadataFilePath));
                } else {
                    log.debug("MetadataFilePath not supplied. Using URL based metadata resolver");
                    this.resolver = new HTTPMetadataResolver((HttpClient)httpClient, this.metadataURL);
                }
                this.resolver.setId(this.entityId);
                this.resolver.setMinRefreshDelay(3600000L * (long)config.getIdpMetadataMinRefreshDelay());
                this.resolver.setMaxRefreshDelay(3600000L * (long)config.getIdpMetadataMaxRefreshDelay());
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | ResolverException e) {
                throw new InternalException("Could not create MetadataResolver", (Exception)e);
            }
            BasicParserPool parserPool = new BasicParserPool();
            this.resolver.setParserPool((ParserPool)parserPool);
            try {
                parserPool.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new InternalException("Could not initialize parser pool", (Exception)((Object)e));
            }
            try {
                this.resolver.initialize();
            }
            catch (ComponentInitializationException e) {
                throw new ExternalException("Could not initialize MetadataResolver", (Exception)((Object)e));
            }
        }
    }
}

