/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import java.util.ArrayList;
import org.opensaml.core.config.InitializationException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionService {
    private static final Logger log = LoggerFactory.getLogger(AssertionService.class);

    public Assertion getAssertion(Response response) throws InternalException, ExternalException {
        if (response.getEncryptedAssertions().size() > 0) {
            EncryptedAssertion encryptedAssertion = (EncryptedAssertion)response.getEncryptedAssertions().get(0);
            return this.decryptAssertion(encryptedAssertion);
        }
        if (response.getAssertions().size() > 0) {
            return (Assertion)response.getAssertions().get(0);
        }
        throw new ExternalException("No assertion in SAML response!");
    }

    private Assertion decryptAssertion(EncryptedAssertion encryptedAssertion) throws InternalException, ExternalException {
        log.debug("Decrypting Assertion");
        try {
            StaticKeyInfoCredentialResolver keyResolver = null;
            try {
                ArrayList<BasicX509Credential> credentials = new ArrayList<BasicX509Credential>();
                credentials.add(OIOSAML3Service.getCredentialService().getPrimaryBasicX509Credential());
                BasicX509Credential secondaryBasicX509Credential = OIOSAML3Service.getCredentialService().getSecondaryBasicX509Credential();
                if (secondaryBasicX509Credential != null) {
                    credentials.add(secondaryBasicX509Credential);
                }
                keyResolver = new StaticKeyInfoCredentialResolver(credentials);
            }
            catch (InitializationException e) {
                throw new InternalException("CredentialService was not initialized", (Exception)((Object)e));
            }
            ArrayList<Object> encryptedKeyResolvers = new ArrayList<Object>();
            encryptedKeyResolvers.add(new InlineEncryptedKeyResolver());
            encryptedKeyResolvers.add(new EncryptedElementTypeEncryptedKeyResolver());
            encryptedKeyResolvers.add(new SimpleRetrievalMethodEncryptedKeyResolver());
            ChainingEncryptedKeyResolver kekResolver = new ChainingEncryptedKeyResolver(encryptedKeyResolvers);
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, (EncryptedKeyResolver)kekResolver);
            decrypter.setRootInNewDocument(true);
            return decrypter.decrypt(encryptedAssertion);
        }
        catch (DecryptionException e) {
            throw new ExternalException("Could not decrypt provided EncryptedAssertion", (Exception)((Object)e));
        }
    }
}

