/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.service.IdPMetadataService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnRequestService {
    private static final Logger log = LoggerFactory.getLogger(AuthnRequestService.class);
    private static AuthnRequestService singleInstance = new AuthnRequestService();

    public static AuthnRequestService getInstance() {
        return singleInstance;
    }

    public MessageContext<SAMLObject> getMessageContext(HttpServletRequest request) throws ComponentInitializationException, MessageDecodingException {
        log.debug("Decoding Http Redirect deflate");
        HTTPRedirectDeflateDecoder decoder = new HTTPRedirectDeflateDecoder();
        decoder.setHttpServletRequest(request);
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        decoder.setParserPool((ParserPool)parserPool);
        decoder.initialize();
        decoder.decode();
        MessageContext msgContext = decoder.getMessageContext();
        decoder.destroy();
        return msgContext;
    }

    public AuthnRequest getAuthnRequest(HttpServletRequest request) throws ComponentInitializationException, MessageDecodingException {
        MessageContext<SAMLObject> messageContext = this.getMessageContext(request);
        return (AuthnRequest)messageContext.getMessage();
    }

    public MessageContext<SAMLObject> createMessageWithAuthnRequest(boolean isPassive, boolean forceAuthn, NSISLevel requiredNsisLevel, String attributeProfile) throws InternalException, ExternalException, InitializationException {
        MessageContext messageContext = new MessageContext();
        String destination = this.getDestination();
        AuthnRequest newAuthnRequest = this.createAuthnRequest(destination, isPassive, forceAuthn, requiredNsisLevel, attributeProfile);
        messageContext.setMessage((Object)newAuthnRequest);
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        SingleSignOnService endpoint = SamlHelper.build(SingleSignOnService.class);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        endpoint.setLocation(destination);
        endpointContext.setEndpoint((Endpoint)endpoint);
        SignatureSigningParameters signatureSigningParameters = new SignatureSigningParameters();
        signatureSigningParameters.setSigningCredential((Credential)OIOSAML3Service.getCredentialService().getPrimaryBasicX509Credential());
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)("_" + UUID.randomUUID().toString()));
        signatureSigningParameters.setSignatureAlgorithm(OIOSAML3Service.getConfig().getSignatureAlgorithm());
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signatureSigningParameters);
        return messageContext;
    }

    public AuthnRequest createAuthnRequest(String destination, boolean isPassive, boolean forceAuthn, NSISLevel requiredNsisLevel) throws InitializationException {
        return this.createAuthnRequest(destination, isPassive, forceAuthn, requiredNsisLevel, null);
    }

    public AuthnRequest createAuthnRequest(String destination, boolean isPassive, boolean forceAuthn, NSISLevel requiredNsisLevel, String attributeProfile) throws InitializationException {
        AuthnContextClassRef authnContextClassRef;
        AuthnRequest authnRequest = SamlHelper.build(AuthnRequest.class);
        RandomIdentifierGenerationStrategy secureRandomIdGenerator = new RandomIdentifierGenerationStrategy();
        String id = secureRandomIdGenerator.generateIdentifier();
        authnRequest.setID(id);
        Configuration config = OIOSAML3Service.getConfig();
        authnRequest.setDestination(destination);
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setIsPassive(Boolean.valueOf(isPassive));
        authnRequest.setForceAuthn(Boolean.valueOf(forceAuthn));
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setAssertionConsumerServiceURL(config.getServletAssertionConsumerURL());
        Issuer issuer = SamlHelper.build(Issuer.class);
        authnRequest.setIssuer(issuer);
        issuer.setValue(config.getSpEntityID());
        ArrayList<AuthnContextClassRef> authnContextClassRefs = new ArrayList<AuthnContextClassRef>();
        if (requiredNsisLevel != null && requiredNsisLevel != NSISLevel.NONE) {
            authnContextClassRef = SamlHelper.build(AuthnContextClassRef.class);
            authnContextClassRef.setAuthnContextClassRef(requiredNsisLevel.getUrl());
            authnContextClassRefs.add(authnContextClassRef);
        }
        if ("https://data.gov.dk/eid/Person".equals(attributeProfile) || "https://data.gov.dk/eid/Professional".equals(attributeProfile)) {
            authnContextClassRef = SamlHelper.build(AuthnContextClassRef.class);
            authnContextClassRef.setAuthnContextClassRef(attributeProfile);
            authnContextClassRefs.add(authnContextClassRef);
        }
        if (!authnContextClassRefs.isEmpty()) {
            RequestedAuthnContext requestedAuthnContext = SamlHelper.build(RequestedAuthnContext.class);
            if (requiredNsisLevel != null && requiredNsisLevel != NSISLevel.NONE) {
                requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
            }
            requestedAuthnContext.getAuthnContextClassRefs().addAll(authnContextClassRefs);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        }
        return authnRequest;
    }

    private String getDestination() throws ExternalException, InternalException {
        EntityDescriptor metadata = IdPMetadataService.getInstance().getIdPMetadata().getEntityDescriptor();
        IDPSSODescriptor idpssoDescriptor = metadata.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        for (SingleSignOnService singleSignOnService : idpssoDescriptor.getSingleSignOnServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(singleSignOnService.getBinding())) continue;
            return singleSignOnService.getLocation();
        }
        throw new ExternalException("Could not find SSO endpoint for Redirect binding in metadata");
    }
}

