/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.model.IdPMetadata;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;

public class IdPMetadataService {
    private static IdPMetadataService singleInstance = new IdPMetadataService();
    private Map<String, IdPMetadata> identityProviders = new HashMap<String, IdPMetadata>();

    public static IdPMetadataService getInstance() {
        return singleInstance;
    }

    public void clear(String entityId) {
        this.identityProviders.remove(entityId);
    }

    public void clearAll() {
        this.identityProviders.clear();
    }

    public IdPMetadata getIdPMetadata() throws ExternalException, InternalException {
        Configuration config = OIOSAML3Service.getConfig();
        return this.getIdPMetadata(config.getIdpEntityID(), config.getIdpMetadataUrl(), config.getIdpMetadataFile());
    }

    public SingleLogoutService getLogoutEndpoint() throws InternalException, ExternalException {
        return this.getIdPMetadata().getLogoutEndpoint();
    }

    public String getLogoutResponseEndpoint() throws InternalException, ExternalException {
        return this.getIdPMetadata().getLogoutResponseEndpoint();
    }

    private IdPMetadata getIdPMetadata(String idpEntityID, String idpMetadataURL, String idpMetadataFilePath) throws InternalException, ExternalException {
        IdPMetadata idPMetadata = this.identityProviders.get(idpEntityID);
        if (idPMetadata == null) {
            idPMetadata = new IdPMetadata(idpEntityID, idpMetadataURL, idpMetadataFilePath);
            this.identityProviders.put(idpEntityID, idPMetadata);
        }
        return idPMetadata;
    }
}

