/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;

public class LogoutRequestService {
    public void validateLogoutRequest() {
    }

    public static MessageContext<SAMLObject> createMessageWithLogoutRequest(String nameID, String nameIDFormat, String destination, String index) throws InitializationException, InternalException {
        MessageContext messageContext = new MessageContext();
        LogoutRequest outgoingLogoutRequest = LogoutRequestService.createLogoutRequest(nameID, nameIDFormat, destination, index);
        messageContext.setMessage((Object)outgoingLogoutRequest);
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        SingleSignOnService endpoint = SamlHelper.build(SingleSignOnService.class);
        endpointContext.setEndpoint((Endpoint)endpoint);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        endpoint.setLocation(destination);
        SignatureSigningParameters signatureSigningParameters = new SignatureSigningParameters();
        signatureSigningParameters.setSigningCredential((Credential)OIOSAML3Service.getCredentialService().getPrimaryBasicX509Credential());
        signatureSigningParameters.setSignatureAlgorithm(OIOSAML3Service.getConfig().getSignatureAlgorithm());
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signatureSigningParameters);
        return messageContext;
    }

    private static LogoutRequest createLogoutRequest(String nameID, String nameIDFormat, String destination, String index) throws InitializationException {
        LogoutRequest outgoingLR = SamlHelper.build(LogoutRequest.class);
        RandomIdentifierGenerationStrategy secureRandomIdGenerator = new RandomIdentifierGenerationStrategy();
        String id = secureRandomIdGenerator.generateIdentifier();
        outgoingLR.setID(id);
        outgoingLR.setDestination(destination);
        outgoingLR.setIssueInstant(new DateTime());
        Issuer issuer = SamlHelper.build(Issuer.class);
        outgoingLR.setIssuer(issuer);
        issuer.setValue(OIOSAML3Service.getConfig().getSpEntityID());
        NameID nameIDObj = SamlHelper.build(NameID.class);
        outgoingLR.setNameID(nameIDObj);
        nameIDObj.setFormat(nameIDFormat);
        nameIDObj.setValue(nameID);
        if (index != null) {
            SessionIndex sessionIndex = SamlHelper.build(SessionIndex.class);
            sessionIndex.setSessionIndex(index);
            outgoingLR.getSessionIndexes().add(sessionIndex);
        }
        return outgoingLR;
    }
}

