/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.LogoutRequestWrapper;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutResponseService {
    private static final Logger log = LoggerFactory.getLogger(LogoutResponseService.class);

    public void validateLogoutResponse() {
    }

    public static MessageContext<SAMLObject> createMessageWithLogoutResponse(LogoutRequestWrapper logoutRequest, String destination) throws InitializationException, InternalException {
        log.debug("Create and sign logout response message for  request id '{}'", (Object)logoutRequest.getID());
        MessageContext messageContext = new MessageContext();
        LogoutResponse logoutResponse = LogoutResponseService.signResponse(LogoutResponseService.createLogoutResponse(destination, logoutRequest));
        messageContext.setMessage((Object)logoutResponse);
        SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        SAMLEndpointContext endpointContext = (SAMLEndpointContext)peerEntityContext.getSubcontext(SAMLEndpointContext.class, true);
        SingleSignOnService endpoint = SamlHelper.build(SingleSignOnService.class);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        endpoint.setLocation(destination);
        endpointContext.setEndpoint((Endpoint)endpoint);
        SignatureSigningParameters signatureSigningParameters = new SignatureSigningParameters();
        signatureSigningParameters.setSigningCredential((Credential)OIOSAML3Service.getCredentialService().getPrimaryBasicX509Credential());
        signatureSigningParameters.setSignatureAlgorithm(OIOSAML3Service.getConfig().getSignatureAlgorithm());
        ((SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(signatureSigningParameters);
        return messageContext;
    }

    private static LogoutResponse createLogoutResponse(String destination, LogoutRequestWrapper logoutRequest) throws InitializationException {
        log.debug("Create logout response message for  request id '{}'", (Object)logoutRequest.getID());
        LogoutResponse logoutResponse = SamlHelper.build(LogoutResponse.class);
        RandomIdentifierGenerationStrategy randomIdentifierGenerator = new RandomIdentifierGenerationStrategy();
        String id = randomIdentifierGenerator.generateIdentifier();
        log.debug("Created logout response id '{}' for  request id '{}'", (Object)id, (Object)logoutRequest.getID());
        logoutResponse.setID(id);
        logoutResponse.setDestination(destination);
        logoutResponse.setIssueInstant(new DateTime());
        logoutResponse.setInResponseTo(logoutRequest.getID());
        Issuer issuer = SamlHelper.build(Issuer.class);
        logoutResponse.setIssuer(issuer);
        issuer.setValue(OIOSAML3Service.getConfig().getSpEntityID());
        Status status = SamlHelper.build(Status.class);
        logoutResponse.setStatus(status);
        StatusCode statusCode = SamlHelper.build(StatusCode.class);
        status.setStatusCode(statusCode);
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        return logoutResponse;
    }

    private static LogoutResponse signResponse(LogoutResponse logoutResponse) {
        log.debug("Signing logout response message with id '{}'", (Object)logoutResponse.getID());
        try {
            Signature signature = SamlHelper.build(Signature.class);
            BasicX509Credential x509Credential = OIOSAML3Service.getCredentialService().getPrimaryBasicX509Credential();
            SignatureRSASHA256 signatureRSASHA256 = new SignatureRSASHA256();
            signature.setSigningCredential((Credential)x509Credential);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.setSignatureAlgorithm(signatureRSASHA256.getURI());
            signature.setKeyInfo(OIOSAML3Service.getCredentialService().getPublicKeyInfo(x509Credential));
            logoutResponse.setSignature(signature);
            SamlHelper.marshallObject((XMLObject)logoutResponse);
            Signer.signObject((Signature)signature);
        }
        catch (InternalException | InitializationException | MarshallingException | SignatureException e) {
            log.warn("Signing of '{}' failed", (Object)logoutResponse.getID(), (Object)e);
        }
        return logoutResponse;
    }
}

