/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.audit.AuditService;
import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.service.CredentialService;
import dk.gov.oio.saml.session.InternalSessionHandlerFactory;
import dk.gov.oio.saml.session.SessionCleanerService;
import dk.gov.oio.saml.session.SessionHandlerFactory;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.xmlsec.config.impl.JavaCryptoValidationInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIOSAML3Service {
    private static final Logger log = LoggerFactory.getLogger(OIOSAML3Service.class);
    public static boolean initialized = false;
    private static Configuration configuration;
    private static AuditService auditService;
    private static CredentialService credentialService;
    private static SessionHandlerFactory sessionHandlerFactory;
    private static SessionCleanerService sessionCleanerService;

    public static void init(Configuration configuration) throws InitializationException {
        log.debug("Initializing OIOSAML");
        initialized = false;
        try {
            log.debug("Validating Java Cryptographic Architecture");
            JavaCryptoValidationInitializer cryptoValidationInitializer = new JavaCryptoValidationInitializer();
            cryptoValidationInitializer.init();
            log.debug("Initializing OpenSAML");
            InitializationService.initialize();
            log.debug("Setting OIOSAML Configuration");
            OIOSAML3Service.configuration = configuration;
            auditService = new AuditService(configuration);
            credentialService = new CredentialService(configuration);
            sessionCleanerService = new SessionCleanerService(configuration);
            sessionHandlerFactory = new InternalSessionHandlerFactory();
            sessionHandlerFactory.configure(configuration);
            initialized = true;
        }
        catch (Exception exception) {
            log.error("Unable to initialize OIOSAML", (Throwable)exception);
            throw new InitializationException(String.format("Unable to initialize OIOSAML '%s'", exception.getMessage()), (Throwable)exception);
        }
        log.debug("OIOSAML Initialized");
    }

    public static Configuration getConfig() throws RuntimeException {
        OIOSAML3Service.ifNotInitializedThrowRuntimeException("Configuration");
        return configuration;
    }

    public static AuditService getAuditService() throws RuntimeException {
        OIOSAML3Service.ifNotInitializedThrowRuntimeException("AuditService");
        return auditService;
    }

    public static SessionHandlerFactory getSessionHandlerFactory() throws RuntimeException {
        OIOSAML3Service.ifNotInitializedThrowRuntimeException("SessionHandlerFactory");
        return sessionHandlerFactory;
    }

    public static SessionCleanerService getSessionCleanerService() {
        OIOSAML3Service.ifNotInitializedThrowRuntimeException("SessionCleanerService");
        return sessionCleanerService;
    }

    public static CredentialService getCredentialService() {
        OIOSAML3Service.ifNotInitializedThrowRuntimeException("CredentialService");
        return credentialService;
    }

    private static void ifNotInitializedThrowRuntimeException(String entity) {
        if (!initialized) {
            throw new RuntimeException(String.format("OIOSAML3 is uninitialized, '%s' is unavailable", entity));
        }
    }
}

