/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.service.CredentialService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ServiceName;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorMarshaller;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.w3c.dom.Element;

public class SPMetadataService {
    private static SPMetadataService singleInstance = new SPMetadataService();
    private String marshalledMetadata;

    public static SPMetadataService getInstance() {
        return singleInstance;
    }

    public String getMarshalledMetadata() throws InternalException, InitializationException {
        if (this.marshalledMetadata == null) {
            this.createMetadata();
        }
        return this.marshalledMetadata;
    }

    public void createMetadata() throws InternalException, InitializationException {
        Configuration config = OIOSAML3Service.getConfig();
        EntityDescriptor entityDescriptor = this.createEntityDescriptor(config.getSpEntityID());
        SPSSODescriptor spssoDescriptor = SamlHelper.build(SPSSODescriptor.class);
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor);
        spssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        spssoDescriptor.setWantAssertionsSigned(Boolean.valueOf(true));
        NameIDFormat nameIDFormat = SamlHelper.build(NameIDFormat.class);
        nameIDFormat.setFormat(config.getNameIDFormat());
        spssoDescriptor.getNameIDFormats().add(nameIDFormat);
        ServiceName serviceName = SamlHelper.build(ServiceName.class);
        serviceName.setXMLLang("da");
        serviceName.setValue(config.getSpEntityID());
        AttributeConsumingService attributeConsumingService = SamlHelper.build(AttributeConsumingService.class);
        attributeConsumingService.setIsDefault(Boolean.valueOf(true));
        attributeConsumingService.getNames().add(serviceName);
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/specVersion", true));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/bootstrapToken", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/privilegesIntermediate", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/concept/core/nsis/loa", true));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/concept/core/nsis/ial", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/concept/core/nsis/aal", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/fullName", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/firstName", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/lastName", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/email", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/cprNumber", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/age", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/cprUuid", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/dateOfBirth", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/person/pid", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/uuid/persistent", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/rid", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/cvr", true));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/orgName", true));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/productionUnit", false));
        attributeConsumingService.getRequestAttributes().add(this.buildRequiredAttribute("https://data.gov.dk/model/core/eid/professional/seNumber", false));
        spssoDescriptor.getAttributeConsumingServices().add(attributeConsumingService);
        List keyDescriptors = spssoDescriptor.getKeyDescriptors();
        keyDescriptors.addAll(this.getKeyDescriptors());
        AssertionConsumerService assertionConsumerService = SamlHelper.build(AssertionConsumerService.class);
        spssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        assertionConsumerService.setLocation(config.getServletAssertionConsumerURL());
        assertionConsumerService.setIsDefault(Boolean.valueOf(true));
        assertionConsumerService.setIndex(Integer.valueOf(0));
        SingleLogoutService singleLogoutService = SamlHelper.build(SingleLogoutService.class);
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutService);
        singleLogoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        singleLogoutService.setLocation(config.getServletLogoutURL());
        singleLogoutService.setResponseLocation(config.getServletLogoutResponseURL());
        singleLogoutService = SamlHelper.build(SingleLogoutService.class);
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutService);
        singleLogoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        singleLogoutService.setLocation(config.getServletLogoutURL());
        singleLogoutService.setResponseLocation(config.getServletLogoutResponseURL());
        singleLogoutService = SamlHelper.build(SingleLogoutService.class);
        spssoDescriptor.getSingleLogoutServices().add(singleLogoutService);
        singleLogoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        singleLogoutService.setLocation(config.getServletLogoutURL());
        singleLogoutService.setResponseLocation(config.getServletLogoutResponseURL());
        String contactEmail = config.getContactEmail();
        if (contactEmail != null && !"".equals(contactEmail)) {
            EmailAddress emailAddress = SamlHelper.build(EmailAddress.class);
            emailAddress.setAddress(contactEmail);
            ContactPerson contactPerson = SamlHelper.build(ContactPerson.class);
            contactPerson.setType(ContactPersonTypeEnumeration.TECHNICAL);
            contactPerson.getEmailAddresses().add(emailAddress);
            spssoDescriptor.getContactPersons().add(contactPerson);
        }
        this.marshalledMetadata = this.marshallMetadata(entityDescriptor);
    }

    private RequestedAttribute buildRequiredAttribute(String attribute, boolean required) {
        RequestedAttribute requestedAttribute = SamlHelper.build(RequestedAttribute.class);
        requestedAttribute.setName(attribute);
        requestedAttribute.setFriendlyName("");
        requestedAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        requestedAttribute.setIsRequired(Boolean.valueOf(required));
        return requestedAttribute;
    }

    private String marshallMetadata(EntityDescriptor entityDescriptor) throws InternalException {
        try {
            EntityDescriptorMarshaller entityDescriptorMarshaller = new EntityDescriptorMarshaller();
            Element element = entityDescriptorMarshaller.marshall((XMLObject)entityDescriptor);
            DOMSource source = new DOMSource(element);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StringWriter buffer = new StringWriter();
            transformer.transform(source, new StreamResult(buffer));
            return buffer.toString();
        }
        catch (TransformerException | MarshallingException e) {
            throw new InternalException("Could not marshall metadata", (Exception)e);
        }
    }

    private EntityDescriptor createEntityDescriptor(String entityID) {
        EntityDescriptor entityDescriptor = SamlHelper.build(EntityDescriptor.class);
        entityDescriptor.setEntityID(entityID);
        entityDescriptor.setID("_" + UUID.nameUUIDFromBytes(entityID.getBytes()).toString());
        return entityDescriptor;
    }

    private List<KeyDescriptor> getKeyDescriptors() throws InternalException {
        try {
            ArrayList<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
            CredentialService credentialService = OIOSAML3Service.getCredentialService();
            BasicX509Credential primaryBasicX509Credential = credentialService.getPrimaryBasicX509Credential();
            keyDescriptors.add(this.getKeyDescriptor(UsageType.SIGNING, credentialService.getPublicKeyInfo(primaryBasicX509Credential)));
            keyDescriptors.add(this.getKeyDescriptor(UsageType.ENCRYPTION, credentialService.getPublicKeyInfo(primaryBasicX509Credential)));
            BasicX509Credential secondaryBasicX509Credential = credentialService.getSecondaryBasicX509Credential();
            if (secondaryBasicX509Credential != null) {
                keyDescriptors.add(this.getKeyDescriptor(UsageType.SIGNING, credentialService.getPublicKeyInfo(secondaryBasicX509Credential)));
                keyDescriptors.add(this.getKeyDescriptor(UsageType.ENCRYPTION, credentialService.getPublicKeyInfo(secondaryBasicX509Credential)));
            }
            return keyDescriptors;
        }
        catch (InitializationException e) {
            throw new InternalException("CredentialService was not initialized", (Exception)((Object)e));
        }
    }

    private KeyDescriptor getKeyDescriptor(UsageType usageType, KeyInfo keyInfo) {
        KeyDescriptor keyDescriptor = SamlHelper.build(KeyDescriptor.class);
        keyDescriptor.setUse(usageType);
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }
}

