/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.service.validation;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.service.IdPMetadataService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.AuthnRequestWrapper;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.ReceivedEndpointSecurityHandler;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionValidationService {
    private static final Logger log = LoggerFactory.getLogger(AssertionValidationService.class);

    public void validate(HttpServletRequest httpServletRequest, MessageContext<SAMLObject> messageContext, Response response, Assertion assertion, AuthnRequestWrapper authnRequest) throws AssertionValidationException, InternalException, ExternalException {
        this.validateDestination(httpServletRequest, messageContext);
        this.validateLifetime(messageContext, response, assertion);
        this.validateResponse(response, authnRequest);
        this.validateAssertion(assertion, authnRequest);
    }

    private void validateDestination(HttpServletRequest httpServletRequest, MessageContext<SAMLObject> messageContext) throws InternalException, ExternalException {
        ReceivedEndpointSecurityHandler endpointSecurityHandler = null;
        try {
            endpointSecurityHandler = new ReceivedEndpointSecurityHandler();
            endpointSecurityHandler.setHttpServletRequest(httpServletRequest);
            endpointSecurityHandler.initialize();
            endpointSecurityHandler.invoke(messageContext);
        }
        catch (ComponentInitializationException e) {
            throw new InternalException("Could not initialize ReceivedEndpointSecurityHandler", (Exception)((Object)e));
        }
        catch (MessageHandlerException e) {
            throw new ExternalException("Destination incorrect", (Exception)((Object)e));
        }
        finally {
            if (endpointSecurityHandler != null && endpointSecurityHandler.isInitialized() && !endpointSecurityHandler.isDestroyed()) {
                endpointSecurityHandler.destroy();
            }
        }
    }

    private void validateLifetime(MessageContext<SAMLObject> messageContext, Response response, Assertion assertion) throws InternalException, AssertionValidationException {
        int clockSkew = OIOSAML3Service.getConfig().getClockSkew();
        MessageLifetimeSecurityHandler lifetimeHandler = null;
        try {
            lifetimeHandler = new MessageLifetimeSecurityHandler();
            lifetimeHandler.setClockSkew(60000L * (long)clockSkew);
            lifetimeHandler.initialize();
            lifetimeHandler.invoke(messageContext);
        }
        catch (ComponentInitializationException e) {
            throw new InternalException("Could not initialize MessageLifetimeSecurityHandler", (Exception)((Object)e));
        }
        catch (MessageHandlerException e) {
            throw new AssertionValidationException("Message lifetime incorrect", (Exception)((Object)e));
        }
        finally {
            if (lifetimeHandler != null && lifetimeHandler.isInitialized() && !lifetimeHandler.isDestroyed()) {
                lifetimeHandler.destroy();
            }
        }
        DateTime responseIssueInstant = response.getIssueInstant();
        if (responseIssueInstant.isBefore((ReadableInstant)DateTime.now().minusMinutes(clockSkew))) {
            throw new AssertionValidationException("Response Lifetime incorrect");
        }
        DateTime assertionIssueInstant = assertion.getIssueInstant();
        if (assertionIssueInstant.isBefore((ReadableInstant)DateTime.now().minusMinutes(clockSkew))) {
            throw new AssertionValidationException("Assertion Lifetime incorrect");
        }
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            if (conditions.getNotOnOrAfter() != null && !DateTime.now().minusMinutes(clockSkew).isBefore((ReadableInstant)conditions.getNotOnOrAfter())) {
                throw new AssertionValidationException("Assertion conditions notOnOrAfter expired");
            }
            if (conditions.getNotBefore() != null && !DateTime.now().plusMinutes(clockSkew).isAfter((ReadableInstant)conditions.getNotBefore())) {
                throw new AssertionValidationException("Assertion conditions notBefore not reached yet");
            }
        }
    }

    private void validateResponse(Response response, AuthnRequestWrapper authnRequest) throws AssertionValidationException {
        this.validateStatus(response);
        this.validateInResponseTo(response, authnRequest);
        Configuration config = OIOSAML3Service.getConfig();
        if (config.isValidationEnabled()) {
            List assertions;
            if (response.isSigned()) {
                log.warn("Successful responses SHOULD NOT be directly signed.");
            }
            if ((assertions = response.getAssertions()) != null && assertions.size() != 0) {
                throw new AssertionValidationException("MUST contain exactly one SAML Assertion, which should be encrypted");
            }
            List encryptedAssertions = response.getEncryptedAssertions();
            if (encryptedAssertions == null || encryptedAssertions.size() != 1) {
                throw new AssertionValidationException("MUST contain exactly one SAML Assertion");
            }
        }
    }

    private void validateAssertion(Assertion assertion, AuthnRequestWrapper authnRequest) throws AssertionValidationException, ExternalException, InternalException {
        this.validateSignature(assertion);
        this.validateIssuer(assertion);
        Configuration config = OIOSAML3Service.getConfig();
        if (config.isValidationEnabled()) {
            this.validateSubject(assertion, authnRequest);
        }
        this.validateAudienceRestriction(assertion);
        List authnStatements = assertion.getAuthnStatements();
        if (authnStatements == null || authnStatements.size() != 1) {
            throw new AssertionValidationException("Assertions MUST contain exactly one AuthnStatement sub-element");
        }
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements == null || attributeStatements.size() != 1) {
            throw new AssertionValidationException("Assertions MUST contain exactly one AttributeStatement sub-element");
        }
        Map<String, String> attributeValues = SamlHelper.extractAttributeValues((AttributeStatement)attributeStatements.get(0));
        if (!config.isValidationEnabled()) {
            return;
        }
        String nameIDValue = assertion.getSubject().getNameID().getValue();
        this.validateAttributeStatement(attributeValues, nameIDValue.startsWith("https://data.gov.dk/model/core/eid/professional"));
        this.validateAssurance(attributeValues, authnRequest);
        if (!assertion.isSigned()) {
            throw new AssertionValidationException("The Assertion within the response MUST be directly signed");
        }
    }

    private void validateAttributeStatement(Map<String, String> attributes, boolean isProfessional) throws AssertionValidationException {
        String specVersion = attributes.get("https://data.gov.dk/model/core/specVersion");
        if (!"OIO-SAML-3.0".equals(specVersion)) {
            throw new AssertionValidationException("specVersion Was: " + specVersion + " Expected: " + "OIO-SAML-3.0");
        }
        if (isProfessional) {
            String cvr = attributes.get("https://data.gov.dk/model/core/eid/professional/cvr");
            if (cvr == null || !cvr.matches("^\\d{8}$")) {
                throw new AssertionValidationException("CVR should be present and should be an 8-digit number");
            }
            String orgName = attributes.get("https://data.gov.dk/model/core/eid/professional/orgName");
            if (orgName == null || orgName.isEmpty()) {
                throw new AssertionValidationException("Organization Name should be present");
            }
        }
    }

    private void validateAssurance(Map<String, String> attributes, AuthnRequestWrapper authnRequest) throws AssertionValidationException {
        Configuration configuration = OIOSAML3Service.getConfig();
        String assuranceLevel = attributes.get("dk:gov:saml:attribute:AssuranceLevel");
        if (authnRequest.getRequestedNsisLevel() == NSISLevel.NONE && assuranceLevel != null) {
            log.info("Assurance level of {} received. Accepting, requested NSIS LoA was NONE", (Object)assuranceLevel);
            return;
        }
        if (!configuration.isAssuranceLevelAllowed() && assuranceLevel != null) {
            throw new AssertionValidationException("NSIS LoA required, but received AssuranceLevel");
        }
        if (configuration.isAssuranceLevelSufficient(assuranceLevel)) {
            log.info("Assurance level of {} received instead of NSIS LoA. Accepted because of configuration", (Object)assuranceLevel);
            return;
        }
        String loa = attributes.get("https://data.gov.dk/concept/core/nsis/loa");
        if (loa == null) {
            throw new AssertionValidationException("Must Contain Level of assurance");
        }
        NSISLevel actualLevel = NSISLevel.getNSISLevelFromAttributeValue(loa, null);
        if (actualLevel == null) {
            throw new AssertionValidationException("Level of assurance was not correct value. Was: " + loa);
        }
        NSISLevel requestedLevel = NSISLevel.NONE;
        for (String authnContextClassRef : authnRequest.getAuthnContextClassRefValues()) {
            NSISLevel nsisLevelFromLOA = NSISLevel.getNSISLevelFromUrl(authnContextClassRef, null);
            if (nsisLevelFromLOA == null) continue;
            requestedLevel = nsisLevelFromLOA;
        }
        if (requestedLevel.isGreater(actualLevel)) {
            throw new AssertionValidationException("Assertion NSIS Level not sufficient. Was: '" + (Object)((Object)actualLevel) + "' Expected: '" + (Object)((Object)requestedLevel) + "'");
        }
    }

    private void validateStatus(Response response) throws AssertionValidationException {
        if (response.getStatus() == null || response.getStatus().getStatusCode() == null) {
            throw new AssertionValidationException("Response status or Response status statuscode was null");
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            throw new AssertionValidationException("Response status code is not Success. Expected: urn:oasis:names:tc:SAML:2.0:status:Success Was: " + response.getStatus().getStatusCode().getValue());
        }
    }

    private void validateInResponseTo(Response response, AuthnRequestWrapper authnRequest) throws AssertionValidationException {
        if (!Objects.equals(authnRequest.getId(), response.getInResponseTo())) {
            throw new AssertionValidationException("InResponseTo does not match AuthnRequest ID. Expected: " + authnRequest.getId() + " Was: " + response.getInResponseTo());
        }
    }

    private void validateSignature(Assertion assertion) throws ExternalException, InternalException, AssertionValidationException {
        X509Certificate x509Certificate = IdPMetadataService.getInstance().getIdPMetadata().getValidX509Certificate(UsageType.SIGNING);
        BasicX509Credential credential = new BasicX509Credential(x509Certificate);
        try {
            SignatureValidator.validate((Signature)assertion.getSignature(), (Credential)credential);
        }
        catch (SignatureException e) {
            throw new AssertionValidationException("Could not validate assertion signature", (Exception)((Object)e));
        }
    }

    private void validateAudienceRestriction(Assertion assertion) throws AssertionValidationException {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            throw new AssertionValidationException("The assertion MUST contain an AudienceRestriction including the ServiceProvider's unique identifier as an Audience, no conditions present");
        }
        Configuration config = OIOSAML3Service.getConfig();
        List audienceRestrictions = conditions.getAudienceRestrictions();
        boolean found = false;
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            List audiences = audienceRestriction.getAudiences();
            for (Audience audience : audiences) {
                if (!audience.getAudienceURI().equals(config.getSpEntityID())) continue;
                found = true;
            }
        }
        if (!found) {
            throw new AssertionValidationException("The assertion MUST contain an AudienceRestriction including the ServiceProvider's unique identifier as an Audience");
        }
    }

    private void validateSubject(Assertion assertion, AuthnRequestWrapper authnRequest) throws AssertionValidationException {
        Subject subject = assertion.getSubject();
        if (subject == null || subject.getNameID() == null) {
            throw new AssertionValidationException("Assertions MUST contain one Subject");
        }
        NameID nameID = subject.getNameID();
        if (nameID == null) {
            throw new AssertionValidationException("Assertions MUST contain one Subject With a NameID element ");
        }
        if (!"urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(nameID.getFormat()) && !"urn:oasis:names:tc:SAML:2.0:nameid-format:persistent".equals(nameID.getFormat())) {
            throw new AssertionValidationException("Subject NameID should have format set to urn:oasis:names:tc:SAML:2.0:nameid-format:transient or urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        }
        String nameIDValue = nameID.getValue();
        if (nameIDValue == null || !nameIDValue.startsWith("https://data.gov.dk/model/core/eid/")) {
            throw new AssertionValidationException("Subject NameID error");
        }
        try {
            String[] split = nameIDValue.split("/uuid/");
            UUID.fromString(split[split.length - 1]);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionValidationException("Subject NameID should be based on a UUID");
        }
        String shouldStartWith = null;
        for (String string : authnRequest.getAuthnContextClassRefValues()) {
            if ("https://data.gov.dk/eid/Person".equals(string)) {
                shouldStartWith = "https://data.gov.dk/model/core/eid/person";
                break;
            }
            if (!"https://data.gov.dk/eid/Person".equals(string)) continue;
            shouldStartWith = "https://data.gov.dk/model/core/eid/professional";
            break;
        }
        if (shouldStartWith != null && !nameIDValue.startsWith(shouldStartWith)) {
            throw new AssertionValidationException("Subject NameID was: " + nameIDValue + " but the AuthnRequest requested it should be of type: " + shouldStartWith);
        }
        SubjectConfirmation subjectConfirmation = null;
        for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(sc.getMethod())) continue;
            subjectConfirmation = sc;
            break;
        }
        if (subjectConfirmation == null) {
            throw new AssertionValidationException("The Subject element MUST contain at least one SubjectConfirmation with conformation method of urn:oasis:names:tc:SAML:2.0:cm:bearer.");
        }
        SubjectConfirmationData subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData();
        if (subjectConfirmationData == null) {
            throw new AssertionValidationException("The SubjectConfirmation element described above MUST contain a SubjectConfirmationData");
        }
        Configuration config = OIOSAML3Service.getConfig();
        if (!config.getServletAssertionConsumerURL().equals(subjectConfirmationData.getRecipient())) {
            throw new AssertionValidationException("The SubjectConfirmationData element MUST contain a recipient attribute containing the SP's assertion consumer service URL");
        }
        DateTime notOnOrAfter = subjectConfirmationData.getNotOnOrAfter();
        if (notOnOrAfter == null) {
            throw new AssertionValidationException("The SubjectConfirmationData element MUST a NotOnOrAfter attribute");
        }
        if (!DateTime.now().isBefore((ReadableInstant)notOnOrAfter.plusMinutes(config.getClockSkew()))) {
            throw new AssertionValidationException("This instant was validated after SubjectConfirmationData 'NotOnOrAfter' attribute plus clockskew");
        }
    }

    private void validateIssuer(Assertion assertion) throws AssertionValidationException, InternalException, ExternalException {
        Issuer issuer = assertion.getIssuer();
        if (issuer == null) {
            throw new AssertionValidationException("Assertions MUST contain an Issuer");
        }
        String format = issuer.getFormat();
        if (format != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(format)) {
            throw new AssertionValidationException("Issuer format attribute MUST be omitted or have a value of urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        }
        String value = issuer.getValue();
        IdPMetadataService idPMetadataService = IdPMetadataService.getInstance();
        String idpEntityID = idPMetadataService.getIdPMetadata().getEntityDescriptor().getEntityID();
        if (value == null || "".equals(value) || !Objects.equals(value, idpEntityID)) {
            throw new AssertionValidationException("Issuer does not match IdP EntityID from metadata");
        }
    }
}

