/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.servlet;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.servlet.AssertionHandler;
import dk.gov.oio.saml.servlet.ErrorHandler;
import dk.gov.oio.saml.servlet.LogoutRequestHandler;
import dk.gov.oio.saml.servlet.LogoutResponseHandler;
import dk.gov.oio.saml.servlet.MetadataHandler;
import dk.gov.oio.saml.servlet.SAMLHandler;
import dk.gov.oio.saml.util.ExternalException;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.ResourceUtil;
import dk.gov.oio.saml.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 6183080772970327975L;
    private static final Logger log = LoggerFactory.getLogger(DispatcherServlet.class);
    private Map<String, SAMLHandler> handlers;
    private boolean initialized = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        log.debug("Initializing DispatcherServlet");
        super.init(servletConfig);
        this.initServlet();
        log.debug("Initialized DispatcherServlet");
    }

    private void handleOptionalValues(Map<String, String> config, Configuration configuration) {
        Integer i;
        String value = config.get("oiosaml.servlet.profile.validation.enabled");
        if (StringUtil.isNotEmpty(value)) {
            configuration.setValidationEnabled("true".equals(value));
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.profile.validation.assurancelevel.allowed"))) {
            configuration.setAssuranceLevelAllowed("true".equals(value));
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.profile.validation.assurancelevel.minimum"))) {
            try {
                i = Integer.parseInt(value);
                configuration.setMinimumAssuranceLevel(i);
            }
            catch (Exception ex) {
                log.warn("Invalid value {} = {}", new Object[]{"oiosaml.servlet.profile.validation.assurancelevel.minimum", value, ex});
            }
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.trust.selfsigned.certs"))) {
            configuration.setSupportSelfSigned("true".equals(value));
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.revocation.crl.check.enabled"))) {
            configuration.setCRLCheckEnabled("true".equals(value));
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.revocation.ocsp.check.enabled"))) {
            configuration.setOcspCheckEnabled("true".equals(value));
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.metadata.nameid.format"))) {
            configuration.setNameIDFormat(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.metadata.contact.email"))) {
            configuration.setContactEmail(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.page.error"))) {
            configuration.setErrorPage(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.page.login"))) {
            configuration.setLoginPage(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.page.logout"))) {
            configuration.setLogoutPage(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.idp.metadata.refresh.min"))) {
            try {
                i = Integer.parseInt(value);
                configuration.setIdpMetadataMinRefreshDelay(i);
            }
            catch (Exception ex) {
                log.warn("Invalid value {} = {}", new Object[]{"oiosaml.servlet.idp.metadata.refresh.min", value, ex});
            }
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.idp.metadata.refresh.max"))) {
            try {
                i = Integer.parseInt(value);
                configuration.setIdpMetadataMaxRefreshDelay(i);
            }
            catch (Exception ex) {
                log.warn("Invalid value {} = {}", new Object[]{"oiosaml.servlet.idp.metadata.refresh.max", value, ex});
            }
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.keystore.alias"))) {
            configuration.setSecondaryKeyAlias(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.keystore.location"))) {
            configuration.setSecondaryKeystoreLocation(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.secondary.keystore.password"))) {
            configuration.setSecondaryKeystorePassword(value);
        }
        if (StringUtil.isNotEmpty(value = config.get("oiosaml.servlet.signature.algorithm"))) {
            configuration.setSignatureAlgorithm(value);
        }
        value = config.get("oiosaml.servlet.session.handler.inmemory.max.tracked.assertionids");
        try {
            configuration.setSessionHandlerInMemoryMaxNumberOfTrackedAssertionIds(Integer.parseInt(StringUtil.defaultIfEmpty(value, "10000")));
        }
        catch (Exception ex) {
            configuration.setSessionHandlerInMemoryMaxNumberOfTrackedAssertionIds(10000);
            log.warn("Invalid value {} = {}", new Object[]{"oiosaml.servlet.session.handler.inmemory.max.tracked.assertionids", value, ex});
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Received GET ({}{})", (Object)req.getServletPath(), (Object)req.getContextPath());
        }
        if (!this.initialized) {
            this.initServlet();
        }
        Configuration config = OIOSAML3Service.getConfig();
        String[] split = req.getRequestURI().split("/" + config.getServletRoutingPathPrefix() + "/");
        String action = split[split.length - 1];
        SAMLHandler samlHandler = this.handlers.get(action);
        if (samlHandler == null) {
            log.warn("No handler registered for action: {}", (Object)action);
            ErrorHandler.handle(req, res, ErrorHandler.ERROR_TYPE.CONFIGURATION_ERROR, "No handler registered for action: " + action);
            return;
        }
        log.debug("Selected MessageHandler: {}", (Object)samlHandler.getClass().getName());
        try {
            samlHandler.handleGet(req, res);
        }
        catch (ExternalException | InternalException | InitializationException e) {
            log.warn("Unexpected error during SAML processing", e);
            ErrorHandler.handle(req, res, ErrorHandler.ERROR_TYPE.EXCEPTION, e.getMessage());
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Received GET ({}{})", (Object)req.getServletPath(), (Object)req.getContextPath());
        }
        if (!this.initialized) {
            this.initServlet();
        }
        Configuration config = OIOSAML3Service.getConfig();
        String[] split = req.getRequestURI().split("/" + config.getServletRoutingPathPrefix() + "/");
        String action = split[split.length - 1];
        SAMLHandler samlHandler = this.handlers.get(action);
        if (samlHandler == null) {
            log.warn("No handler registered for action: {}", (Object)action);
            ErrorHandler.handle(req, res, ErrorHandler.ERROR_TYPE.CONFIGURATION_ERROR, "No handler registered for action: " + action);
            return;
        }
        log.debug("Selected MessageHandler: {}", (Object)samlHandler.getClass().getName());
        try {
            if (null != req.getHeader("SOAPAction")) {
                samlHandler.handleSOAP(req, res);
            } else {
                samlHandler.handlePost(req, res);
            }
        }
        catch (ExternalException | InternalException e) {
            log.warn("Unexpected error during SAML processing", (Throwable)e);
            ErrorHandler.handle(req, res, ErrorHandler.ERROR_TYPE.EXCEPTION, e.getMessage());
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    private Map<String, String> getInitConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        Enumeration keys = this.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = this.getInitParameter(key);
            configMap.put(key, value);
        }
        configMap.putAll(ResourceUtil.getConfig((String)configMap.get("oiosaml.servlet.configurationfile")));
        return configMap;
    }

    private void initServlet() throws ServletException {
        if (!this.initialized) {
            Map<String, String> config = this.getInitConfig();
            try {
                Configuration configuration = new Configuration.Builder().setSpEntityID(config.get("oiosaml.servlet.entityid")).setBaseUrl(config.get("oiosaml.servlet.baseurl")).setKeystoreLocation(config.get("oiosaml.servlet.keystore.location")).setKeystorePassword(config.get("oiosaml.servlet.keystore.password")).setKeyAlias(config.get("oiosaml.servlet.keystore.alias")).setIdpEntityID(config.get("oiosaml.servlet.idp.entityid")).setIdpMetadataUrl(config.get("oiosaml.servlet.idp.metadata.url")).setIdpMetadataFile(config.get("oiosaml.servlet.idp.metadata.file")).setServletRoutingPathPrefix(config.get("oiosaml.servlet.routing.path.prefix")).setServletRoutingPathSuffixError(config.get("oiosaml.servlet.routing.path.suffix.error")).setServletRoutingPathSuffixMetadata(config.get("oiosaml.servlet.routing.path.suffix.metadata")).setServletRoutingPathSuffixLogout(config.get("oiosaml.servlet.routing.path.suffix.logout")).setServletRoutingPathSuffixLogoutResponse(config.get("oiosaml.servlet.routing.path.suffix.logoutResponse")).setServletRoutingPathSuffixAssertion(config.get("oiosaml.servlet.routing.path.suffix.assertion")).setAuditLoggerClassName(config.get("oiosaml.servlet.audit.logger.classname")).setAuditRequestAttributeIP(config.get("oiosaml.servlet.audit.logger.attribute.ip")).setAuditRequestAttributePort(config.get("oiosaml.servlet.audit.logger.attribute.port")).setAuditRequestAttributeServiceProviderUserId(config.get("oiosaml.servlet.audit.logger.attribute.userid")).setAuditRequestAttributeSessionId(config.get("oiosaml.servlet.audit.logger.attribute.sessionId")).setSessionHandlerFactoryClassName(config.get("oiosaml.servlet.session.handler.factory")).setSessionHandlerJndiName(config.get("oiosaml.servlet.session.handler.jdni.name")).setSessionHandlerJdbcUrl(config.get("oiosaml.servlet.session.handler.jdbc.url")).setSessionHandlerJdbcUsername(config.get("oiosaml.servlet.session.handler.jdbc.username")).setSessionHandlerJdbcPassword(config.get("oiosaml.servlet.session.handler.jdbc.password")).setSessionHandlerJdbcDriverClassName(config.get("oiosaml.servlet.session.handler.jdbc.driver.classname")).build();
                this.handleOptionalValues(config, configuration);
                OIOSAML3Service.init(configuration);
                this.handlers = new HashMap<String, SAMLHandler>();
                this.handlers.put(configuration.getServletRoutingPathSuffixError(), new ErrorHandler());
                this.handlers.put(configuration.getServletRoutingPathSuffixMetadata(), new MetadataHandler());
                this.handlers.put(configuration.getServletRoutingPathSuffixLogout(), new LogoutRequestHandler());
                this.handlers.put(configuration.getServletRoutingPathSuffixLogoutResponse(), new LogoutResponseHandler());
                this.handlers.put(configuration.getServletRoutingPathSuffixAssertion(), new AssertionHandler());
                this.initialized = true;
            }
            catch (InternalException | InitializationException e) {
                throw new ServletException(e);
            }
        }
    }
}

