/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.oiobpp.OIOBPPUtil;
import dk.gov.oio.saml.oiobpp.PrivilegeList;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import dk.gov.oio.saml.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.core.impl.AssertionMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AssertionWrapper
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AssertionWrapper.class);
    private static final long serialVersionUID = -4561395634523843337L;
    private String id;
    private String assertionString;
    private String assertionBase64;
    private String sessionIndex;
    private String issuer;
    private String subjectNameId;
    private String subjectNameIdFormat;
    private String signingCredentialEntityId;
    private List<String> audiences;
    private String authnContextClassRef;
    private PrivilegeList privilegeList;
    private Map<String, String> attributeValues;
    private boolean sessionExpired;
    private DateTime confirmationTime;
    private DateTime conditionTimeNotBefore;
    private DateTime conditionTimeNotOnOrAfter;

    public AssertionWrapper(Assertion assertion) throws InternalException {
        String attributeValue;
        Conditions conditions;
        List attributeStatements;
        this.assertionBase64 = StringUtil.xmlObjectToBase64((XMLObject)assertion);
        AssertionMarshaller marshaller = new AssertionMarshaller();
        try {
            Element element = marshaller.marshall((XMLObject)assertion);
            this.assertionString = StringUtil.elementToString(element);
        }
        catch (MarshallingException e) {
            throw new InternalException((Exception)((Object)e));
        }
        Issuer issuerObj = assertion.getIssuer();
        this.issuer = issuerObj != null ? issuerObj.getValue() : null;
        Subject subject = assertion.getSubject();
        if (subject != null && subject.getNameID() != null) {
            this.subjectNameId = subject.getNameID().getValue();
            this.subjectNameIdFormat = subject.getNameID().getFormat();
        }
        if ((attributeStatements = assertion.getAttributeStatements()) != null && attributeStatements.size() == 1) {
            AttributeStatement attributeStatement = (AttributeStatement)attributeStatements.get(0);
            this.attributeValues = SamlHelper.extractAttributeValues(attributeStatement);
        }
        if ((conditions = assertion.getConditions()) != null) {
            Iterator<String> audiences = new ArrayList<String>();
            for (AudienceRestriction audienceRestriction : conditions.getAudienceRestrictions()) {
                for (Audience audience : audienceRestriction.getAudiences()) {
                    audiences.add(audience.getAudienceURI());
                }
            }
            this.audiences = audiences;
            this.conditionTimeNotOnOrAfter = conditions.getNotOnOrAfter();
            this.conditionTimeNotBefore = conditions.getNotBefore();
        }
        if (assertion.getSubject() != null && assertion.getSubject().getSubjectConfirmations() != null && !assertion.getSubject().getSubjectConfirmations().isEmpty()) {
            for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
                SubjectConfirmationData data = subjectConfirmation.getSubjectConfirmationData();
                if (data == null || data.getNotOnOrAfter() == null) continue;
                this.confirmationTime = data.getNotOnOrAfter();
            }
        }
        if (assertion.getAuthnStatements() != null && assertion.getAuthnStatements().size() > 0) {
            AuthnContextClassRef authnContextClassRef;
            for (AuthnStatement authnStatement : assertion.getAuthnStatements()) {
                if (!StringUtil.isNotEmpty(authnStatement.getSessionIndex())) continue;
                this.sessionIndex = authnStatement.getSessionIndex();
            }
            AuthnStatement authnStatement = (AuthnStatement)assertion.getAuthnStatements().get(0);
            boolean sessionExpired = false;
            if (authnStatement.getSessionNotOnOrAfter() != null) {
                sessionExpired = authnStatement.getSessionNotOnOrAfter().isBeforeNow();
            }
            this.sessionExpired = sessionExpired;
            AuthnContext authnContext = authnStatement.getAuthnContext();
            if (authnContext != null && (authnContextClassRef = authnContext.getAuthnContextClassRef()) != null) {
                this.authnContextClassRef = authnContextClassRef.getAuthnContextClassRef();
            }
        }
        if (this.attributeValues != null && (attributeValue = this.attributeValues.get("https://data.gov.dk/model/core/eid/privilegesIntermediate")) != null) {
            this.privilegeList = OIOBPPUtil.parse(attributeValue);
        }
        if (null != assertion.getSignature() && null != assertion.getSignature().getSigningCredential()) {
            this.signingCredentialEntityId = assertion.getSignature().getSigningCredential().getEntityId();
        }
        this.id = assertion.getID();
    }

    public String getAssertionAsString() {
        return this.assertionString;
    }

    public String getAssertionAsBase64() {
        return this.assertionBase64;
    }

    public String getAssertionAsHtml() {
        return AssertionWrapper.htmlEscape(this.assertionString);
    }

    private static String htmlEscape(String input) {
        StringBuilder escaped = new StringBuilder();
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '<': {
                    escaped.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escaped.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escaped.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escaped.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escaped.append("&#39;");
                    continue block7;
                }
                default: {
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public NSISLevel getNsisLevel() {
        if (this.attributeValues != null) {
            String value = this.attributeValues.get("https://data.gov.dk/concept/core/nsis/loa");
            return NSISLevel.getNSISLevelFromAttributeValue(value, NSISLevel.NONE);
        }
        return NSISLevel.NONE;
    }

    public String getAssuranceLevel() {
        if (this.attributeValues != null) {
            return this.attributeValues.get("dk:gov:saml:attribute:AssuranceLevel");
        }
        return null;
    }

    public String getID() {
        return this.id;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public String getSubjectNameId() {
        return this.subjectNameId;
    }

    public String getSubjectNameIdFormat() {
        return this.subjectNameIdFormat;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAuthnContextClassRef() {
        return this.authnContextClassRef;
    }

    public PrivilegeList getPrivilegeList() {
        return this.privilegeList;
    }

    public Map<String, String> getAttributeValues() {
        return this.attributeValues;
    }

    public boolean isSessionExpired() {
        return this.sessionExpired;
    }

    public DateTime getConfirmationTime() {
        return this.confirmationTime;
    }

    public DateTime getConditionTimeNotBefore() {
        return this.conditionTimeNotBefore;
    }

    public DateTime getConditionTimeNotOnOrAfter() {
        return this.conditionTimeNotOnOrAfter;
    }

    public String getSigningCredentialEntityId() {
        return this.signingCredentialEntityId;
    }

    public boolean isReplayOf(AssertionWrapper assertionWrapper) {
        if (null == assertionWrapper) {
            return false;
        }
        if (StringUtil.isEmpty(assertionWrapper.getID()) || StringUtil.isEmpty(assertionWrapper.getSessionIndex())) {
            return false;
        }
        return assertionWrapper.getSessionIndex().equals(this.getSessionIndex()) && assertionWrapper.getID().equals(this.getID());
    }

    public String toString() {
        return String.format("AssertionWrapper{assertion='%s'}", this.assertionString);
    }
}

