/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;

public class AuthnRequestWrapper
implements Serializable {
    private static final long serialVersionUID = -2647272712207296480L;
    private String id;
    private boolean forceAuthn;
    private boolean passive;
    private NSISLevel requestedNsisLevel;
    private List<String> authnContextClassRefValues;
    private String issuer;
    private String issueInstant;
    private String destination;
    private String authnRequestAsBase64;
    private String requestPath;

    public AuthnRequestWrapper(AuthnRequest authnRequest, NSISLevel requestedNsisLevel, String requestPath) throws InternalException {
        this.authnRequestAsBase64 = StringUtil.xmlObjectToBase64((XMLObject)authnRequest);
        this.authnContextClassRefValues = new ArrayList<String>();
        if (authnRequest.getRequestedAuthnContext() != null) {
            List authnContextClassRefs = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs();
            for (AuthnContextClassRef authnContextClassRef : authnContextClassRefs) {
                String value = authnContextClassRef.getAuthnContextClassRef();
                if (!StringUtil.isNotEmpty(value)) continue;
                this.getAuthnContextClassRefValues().add(value);
            }
        }
        this.passive = authnRequest.isPassive();
        this.forceAuthn = authnRequest.isForceAuthn();
        this.requestedNsisLevel = requestedNsisLevel;
        this.requestPath = requestPath;
        this.destination = authnRequest.getDestination();
        Issuer issuer = authnRequest.getIssuer();
        this.issuer = issuer != null ? issuer.getValue() : "";
        DateTime issueInstant = authnRequest.getIssueInstant();
        this.issueInstant = issueInstant != null ? issueInstant.toString() : "";
        this.id = authnRequest.getID();
    }

    public String getId() {
        return this.id;
    }

    public List<String> getAuthnContextClassRefValues() {
        return this.authnContextClassRefValues;
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public NSISLevel getRequestedNsisLevel() {
        return this.requestedNsisLevel;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssueInstant() {
        return this.issueInstant;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getAuthnRequestAsBase64() {
        return this.authnRequestAsBase64;
    }
}

