/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.session.SessionHandlerFactory;
import dk.gov.oio.saml.session.inmemory.InMemorySessionHandlerFactory;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSessionHandlerFactory
implements SessionHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(InternalSessionHandlerFactory.class);
    private SessionHandlerFactory instance;

    @Override
    public void close() {
        try {
            if (null != this.instance) {
                log.debug("Closing SessionHandlerFactory");
                this.instance.close();
            }
        }
        catch (Exception e) {
            log.warn("Failed closing SessionHandlerFactory: {}", (Object)e.getMessage());
        }
        finally {
            this.instance = null;
        }
    }

    @Override
    public SessionHandler getHandler() throws InternalException {
        if (this.instance == null) {
            throw new InternalException("SessionHandlerFactory is uninitialized, configuration is missing");
        }
        return this.instance.getHandler();
    }

    @Override
    public synchronized void configure(Configuration config) throws InitializationException {
        log.debug("Configure session handler factory: '{}'", (Object)config);
        if (null != this.instance) {
            log.warn("Session handler factory already configured");
            return;
        }
        if (null == config) {
            throw new InitializationException("Cannot create SessionHandlerFactory, missing configuration");
        }
        Class clazz = InMemorySessionHandlerFactory.class;
        try {
            String name = config.getSessionHandlerFactoryClassName();
            if (StringUtil.isNotEmpty(name)) {
                log.info("Initializing SessionHandlerFactory '{}'", (Object)name);
                clazz = Class.forName(name);
            }
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                log.info("Create '{}' SessionHandlerFactory", (Object)clazz.getName());
                SessionHandlerFactory sessionHandlerFactory = (SessionHandlerFactory)constructor.newInstance(new Object[0]);
                sessionHandlerFactory.configure(config);
                this.instance = sessionHandlerFactory;
                return;
            }
            log.error("Failed creating SessionHandlerFactory");
            throw new InitializationException(String.format("Cannot create SessionHandlerFactory, '%s' must have default constructor", clazz.getName()));
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error("Failed creating SessionHandlerFactory", (Throwable)e);
            throw new InitializationException(String.format("Cannot create SessionHandlerFactory, '%s' must have default constructor and implement 'dk.gov.oio.saml.audit.AuditLogger'", clazz.getName()), (Throwable)e);
        }
    }
}

