/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;

public class LogoutRequestWrapper {
    private LogoutRequest delegator;

    public LogoutRequestWrapper(LogoutRequest delegator) {
        this.delegator = delegator;
    }

    public LogoutRequest getLogoutRequest() {
        return this.delegator;
    }

    public String getLogoutRequestAsBase64() throws InternalException {
        return StringUtil.xmlObjectToBase64((XMLObject)this.delegator);
    }

    public String getIssuerAsString() {
        return this.delegator.getIssuer() != null ? this.delegator.getIssuer().getValue() : "";
    }

    public String getIssueInstantAsString() {
        return this.delegator.getIssueInstant() != null ? this.delegator.getIssueInstant().toString() : "";
    }

    public String getSessionIndexesAsString() {
        return this.delegator.getSessionIndexes().stream().map(sessionIndex -> sessionIndex.getSessionIndex()).collect(Collectors.joining(", ", "[", "]"));
    }

    public String getSignatureReferenceID() {
        return this.delegator.getSignatureReferenceID();
    }

    public String getReason() {
        return this.delegator.getReason();
    }

    public DateTime getNotOnOrAfter() {
        return this.delegator.getNotOnOrAfter();
    }

    public BaseID getBaseID() {
        return this.delegator.getBaseID();
    }

    public NameID getNameID() {
        return this.delegator.getNameID();
    }

    public List<SessionIndex> getSessionIndexes() {
        return this.delegator.getSessionIndexes();
    }

    public String getID() {
        return this.delegator.getID();
    }

    public DateTime getIssueInstant() {
        return this.delegator.getIssueInstant();
    }

    public String getDestination() {
        return this.delegator.getDestination();
    }

    public Issuer getIssuer() {
        return this.delegator.getIssuer();
    }
}

