/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.session.SessionCleanerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCleanerService {
    private static final Logger log = LoggerFactory.getLogger(SessionCleanerService.class);
    private ScheduledExecutorService scheduledThreadPool;
    private boolean initialized = false;

    public SessionCleanerService(Configuration configuration) {
    }

    public void startCleanerIfMissing(HttpSession session) {
        if (!this.initialized) {
            this.initializeCleanerService(session);
        }
    }

    private synchronized void initializeCleanerService(HttpSession session) {
        if (this.initialized) {
            return;
        }
        long maxInactiveIntervalSeconds = session.getMaxInactiveInterval() > 0 ? (long)session.getMaxInactiveInterval() : 1800L;
        try {
            log.info("Starting session cleaner with timeout '{}'", (Object)maxInactiveIntervalSeconds);
            this.scheduledThreadPool = Executors.newScheduledThreadPool(1);
            this.scheduledThreadPool.scheduleWithFixedDelay(new SessionCleanerTask(maxInactiveIntervalSeconds), 0L, maxInactiveIntervalSeconds, TimeUnit.SECONDS);
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn("Unable to start session cleaner", (Throwable)e);
        }
    }

    public synchronized void stopCleaner() {
        if (this.scheduledThreadPool != null) {
            this.scheduledThreadPool.shutdown();
        }
        this.scheduledThreadPool = null;
        this.initialized = false;
    }
}

