/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.SessionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCleanerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SessionCleanerTask.class);
    private long maxInactiveIntervalSeconds;

    public SessionCleanerTask(long maxInactiveIntervalSeconds) {
        this.maxInactiveIntervalSeconds = maxInactiveIntervalSeconds;
    }

    @Override
    public void run() {
        log.debug("Cleaning session data, time: {}, timeout: {}", (Object)System.currentTimeMillis(), (Object)(this.maxInactiveIntervalSeconds * 1000L));
        try {
            SessionHandler sessionHandler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
            sessionHandler.cleanup(this.maxInactiveIntervalSeconds);
        }
        catch (Exception e) {
            log.warn("Failed removing old session data", (Throwable)e);
        }
    }
}

