/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session;

import dk.gov.oio.saml.audit.AuditService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.AssertionWrapper;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.util.InternalException;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDestroyListener
implements HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(SessionDestroyListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        log.debug("Session: {}", (Object)httpSessionEvent.getSession().getId());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (null == httpSessionEvent.getSession()) {
            log.debug("No session exists in current context");
            return;
        }
        try {
            SessionHandler handler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
            boolean loggedIn = handler.isAuthenticated(httpSessionEvent.getSession());
            String sessionId = handler.getSessionId(httpSessionEvent.getSession());
            log.debug("User on session {} logged in: {}", (Object)sessionId, (Object)loggedIn);
            if (loggedIn) {
                AssertionWrapper assertion = handler.getAssertion(httpSessionEvent.getSession());
                OIOSAML3Service.getAuditService().auditLog(new AuditService.Builder().withAuthnAttribute("ACTION", "TIMEOUT").withAuthnAttribute("DESCRIPTION", "SessionDestroyed").withAuthnAttribute("SP_SESSION_ID", sessionId).withAuthnAttribute("ASSERTION_ID", assertion.getID()).withAuthnAttribute("SUBJECT_NAME_ID", assertion.getSubjectNameId()));
                handler.logout(httpSessionEvent.getSession(), assertion);
            } else {
                log.debug("Session destroyed without saml assertion");
            }
        }
        catch (InternalException ex) {
            log.warn("Failed to logout OIOSAML session {}", (Object)httpSessionEvent.getSession().getId(), (Object)ex);
        }
    }
}

