/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session.database;

import dk.gov.oio.saml.audit.AuditService;
import dk.gov.oio.saml.model.NSISLevel;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.AssertionWrapper;
import dk.gov.oio.saml.session.AuthnRequestWrapper;
import dk.gov.oio.saml.session.LogoutRequestWrapper;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.LocalDateTime;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSessionHandler
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSessionHandler.class);
    private final DataSource ds;

    public DatabaseSessionHandler(DataSource ds) {
        log.debug("Created database session handler");
        this.ds = ds;
    }

    @Override
    public void storeAuthnRequest(HttpSession session, AuthnRequestWrapper request) throws InternalException {
        if (null == request || null == request.getId()) {
            log.warn("Ignore AuthRequest with null value or missing ID");
            return;
        }
        try (Connection connection = this.ds.getConnection();){
            Throwable throwable;
            PreparedStatement ps;
            connection.setAutoCommit(true);
            AuthnRequestWrapper authnRequest = this.getAuthnRequest(session);
            if (null != authnRequest) {
                log.debug("AuthRequest '{}' will replace '{}'", (Object)request.getId(), (Object)authnRequest.getId());
                ps = connection.prepareStatement("DELETE FROM authn_requests_tbl WHERE session_id = ?");
                throwable = null;
                try {
                    ps.setString(1, this.getSessionId(session));
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            log.debug("Store AuthRequest '{}'", (Object)request.getId());
            ps = connection.prepareStatement("INSERT INTO authn_requests_tbl (session_id, access_time, nsis_level, request_path, xml_object) VALUES (?,?,?,?,?)");
            throwable = null;
            try {
                ps.setString(1, this.getSessionId(session));
                ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                ps.setString(3, request.getRequestedNsisLevel().name());
                ps.setString(4, request.getRequestPath());
                ps.setClob(5, new StringReader(request.getAuthnRequestAsBase64()));
                ps.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("Failure to persist authn request", (Throwable)e);
            throw new InternalException("Failure to persist authn request", e);
        }
    }

    @Override
    public void storeAssertion(HttpSession session, AssertionWrapper assertion) throws InternalException {
        if (null == assertion || StringUtil.isEmpty(assertion.getID())) {
            log.warn("Ignore Assertion with null value or missing ID");
            return;
        }
        if (StringUtil.isEmpty(assertion.getSessionIndex())) {
            log.info("Assertion '{}' with passive session and missing index", (Object)assertion.getID());
        }
        try (Connection connection = this.ds.getConnection();){
            Throwable throwable;
            PreparedStatement ps;
            connection.setAutoCommit(true);
            try (PreparedStatement ps2 = connection.prepareStatement("SELECT '1' FROM replay_tbl WHERE assertion_id = ?");){
                ps2.setString(1, assertion.getID());
                try (ResultSet rs = ps2.executeQuery();){
                    if (rs.next()) {
                        throw new IllegalArgumentException(String.format("Assertion with id '%s' and session index '%s' is already registered", assertion.getID(), assertion.getSessionIndex()));
                    }
                }
            }
            AssertionWrapper existingAssertion = this.getAssertion(session);
            if (null != existingAssertion) {
                if (assertion.isReplayOf(existingAssertion)) {
                    log.debug("Assertion '{}' is being replayed", (Object)assertion.getID(), (Object)existingAssertion.getID());
                    throw new IllegalArgumentException(String.format("Assertion with id '%s' and session index '%s' is already registered", assertion.getID(), assertion.getSessionIndex()));
                }
                log.debug("Assertion '{}' will replace '{}'", (Object)assertion.getID(), (Object)existingAssertion.getID());
                ps = connection.prepareStatement("DELETE FROM assertions_tbl WHERE session_id = ?");
                throwable = null;
                try {
                    ps.setString(1, this.getSessionId(session));
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            log.debug("Store Assertion '{}'", (Object)assertion.getID());
            ps = connection.prepareStatement("INSERT INTO assertions_tbl (session_id, session_index, assertion_id, subject_name_id, access_time, xml_object) VALUES (?,?,?,?,?,?)");
            throwable = null;
            try {
                ps.setString(1, this.getSessionId(session));
                ps.setString(2, StringUtil.defaultIfEmpty(assertion.getSessionIndex(), assertion.getID()));
                ps.setString(3, assertion.getID());
                ps.setString(4, assertion.getSubjectNameId());
                ps.setTimestamp(5, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                ps.setClob(6, new StringReader(assertion.getAssertionAsBase64()));
                ps.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            log.debug("Add replay entry for assertion '{}'", (Object)assertion.getID());
            ps = connection.prepareStatement("INSERT INTO replay_tbl (assertion_id, access_time) VALUES (?,?)");
            throwable = null;
            try {
                ps.setString(1, assertion.getID());
                ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                ps.executeUpdate();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("Failure to persist assertion", (Throwable)e);
            throw new InternalException("Failure to persist assertion", e);
        }
    }

    @Override
    public void storeLogoutRequest(HttpSession session, LogoutRequestWrapper request) throws InternalException {
        if (null == request || null == request.getID()) {
            log.warn("Ignore LogoutRequest with null value or missing ID");
            return;
        }
        try (Connection connection = this.ds.getConnection();){
            Throwable throwable;
            PreparedStatement ps;
            connection.setAutoCommit(true);
            LogoutRequestWrapper logoutRequest = this.getLogoutRequest(session);
            if (null != logoutRequest) {
                log.debug("LogoutRequest '{}' will replace '{}'", (Object)request.getID(), (Object)logoutRequest.getID());
                ps = connection.prepareStatement("DELETE FROM logout_requests_tbl WHERE session_id = ?");
                throwable = null;
                try {
                    ps.setString(1, this.getSessionId(session));
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps != null) {
                        if (throwable != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            log.debug("Store LogoutRequest '{}'", (Object)request.getID());
            ps = connection.prepareStatement("INSERT INTO logout_requests_tbl (session_id, access_time, xml_object) VALUES (?,?,?)");
            throwable = null;
            try {
                ps.setString(1, this.getSessionId(session));
                ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                ps.setClob(3, new StringReader(request.getLogoutRequestAsBase64()));
                ps.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("Failure to persist logout request", (Throwable)e);
            throw new InternalException("Failure to persist logout request", e);
        }
    }

    @Override
    public AssertionWrapper getAssertion(HttpSession session) {
        return this.getAssertionFromSessionId(this.getSessionId(session));
    }

    @Override
    public AssertionWrapper getAssertion(String sessionIndex) {
        return this.getAssertionFromSessionId(this.getSessionId(sessionIndex));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AuthnRequestWrapper getAuthnRequest(HttpSession session) {
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            AuthnRequestWrapper authnRequestWrapper = null;
            try (PreparedStatement ps = connection.prepareStatement("SELECT xml_object, nsis_level, request_path FROM authn_requests_tbl WHERE session_id = ?");){
                ps.setString(1, this.getSessionId(session));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        authnRequestWrapper = new AuthnRequestWrapper((AuthnRequest)StringUtil.base64ToXMLObject(rs.getString(1)), NSISLevel.valueOf(rs.getString(2)), rs.getString(3));
                    }
                }
            }
            if (null != authnRequestWrapper) {
                ps = connection.prepareStatement("UPDATE authn_requests_tbl SET access_time = ? WHERE session_id = ?");
                var6_8 = null;
                try {
                    ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                    ps.setString(2, this.getSessionId(session));
                    ps.executeUpdate();
                }
                catch (Throwable throwable) {
                    var6_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (ps != null) {
                        if (var6_8 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            AuthnRequestWrapper authnRequestWrapper2 = authnRequestWrapper;
            return authnRequestWrapper2;
        }
        catch (InternalException | SQLException e) {
            log.error("Failed retrieving authn request matching sessionId", (Throwable)e);
            throw new RuntimeException("Failed retrieving authn request matching sessionId", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LogoutRequestWrapper getLogoutRequest(HttpSession session) {
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            LogoutRequestWrapper logoutRequestWrapper = null;
            try (PreparedStatement ps = connection.prepareStatement("SELECT xml_object FROM logout_requests_tbl WHERE session_id = ?");){
                ps.setString(1, this.getSessionId(session));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        logoutRequestWrapper = new LogoutRequestWrapper((LogoutRequest)StringUtil.base64ToXMLObject(rs.getString(1)));
                    }
                }
            }
            if (null != logoutRequestWrapper) {
                ps = connection.prepareStatement("UPDATE logout_requests_tbl SET access_time = ? WHERE session_id = ?");
                var6_8 = null;
                try {
                    ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                    ps.setString(2, this.getSessionId(session));
                    ps.executeUpdate();
                }
                catch (Throwable throwable) {
                    var6_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (ps != null) {
                        if (var6_8 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            LogoutRequestWrapper logoutRequestWrapper2 = logoutRequestWrapper;
            return logoutRequestWrapper2;
        }
        catch (InternalException | SQLException e) {
            log.error("Failed retrieving authn request matching sessionId", (Throwable)e);
            throw new RuntimeException("Failed retrieving authn request matching sessionId", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSessionId(String sessionIndex) {
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            try (PreparedStatement ps = connection.prepareStatement("SELECT session_id FROM assertions_tbl WHERE session_index = ?");){
                ps.setString(1, sessionIndex);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return null;
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        catch (SQLException e) {
            log.error("Failed retrieving sessionId from session index '{}'", (Object)sessionIndex, (Object)e);
            throw new RuntimeException("Failed retrieving sessionId from session index", e);
        }
    }

    @Override
    public void logout(HttpSession session, AssertionWrapper assertion) {
        log.debug("Logout from session '{}' and assertion '{}'", (Object)(null != session ? this.getSessionId(session) : ""), (Object)(null != assertion ? assertion.getID() : ""));
        if (null != assertion && StringUtil.isNotEmpty(assertion.getSessionIndex())) {
            this.logout(this.getSessionId(assertion.getSessionIndex()));
        }
        this.logout(this.getSessionId(session));
    }

    @Override
    public void cleanup(long maxInactiveIntervalSeconds) {
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            long replayCleanupDelay = 86400L;
            try (PreparedStatement ps = connection.prepareStatement("SELECT session_id, assertion_id, subject_name_id FROM assertions_tbl WHERE access_time < ?");){
                ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone()).minusSeconds(maxInactiveIntervalSeconds)));
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        OIOSAML3Service.getAuditService().auditLog(new AuditService.Builder().withAuthnAttribute("ACTION", "TIMEOUT").withAuthnAttribute("DESCRIPTION", "SessionDestroyed").withAuthnAttribute("SP_SESSION_ID", rs.getString(1)).withAuthnAttribute("ASSERTION_ID", rs.getString(2)).withAuthnAttribute("SUBJECT_NAME_ID", rs.getString(3)));
                    }
                }
            }
            ps = connection.prepareStatement("DELETE FROM assertions_tbl WHERE access_time < ?");
            var8_9 = null;
            try {
                ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone()).minusSeconds(maxInactiveIntervalSeconds)));
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var8_9 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = connection.prepareStatement("DELETE FROM authn_requests_tbl WHERE access_time < ?");
            var8_9 = null;
            try {
                ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone()).minusSeconds(maxInactiveIntervalSeconds)));
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var8_9 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = connection.prepareStatement("DELETE FROM logout_requests_tbl WHERE access_time < ?");
            var8_9 = null;
            try {
                ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone()).minusSeconds(maxInactiveIntervalSeconds)));
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var8_9 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            ps = connection.prepareStatement("DELETE FROM replay_tbl WHERE access_time < ?");
            var8_9 = null;
            try {
                ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone()).minusSeconds(86400L)));
                ps.executeUpdate();
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var8_9 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error("Failed running cleanup", (Throwable)e);
        }
    }

    private void logout(String sessionId) {
        log.debug("Invalidate OIOSAML session '{}'", (Object)sessionId);
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            if (StringUtil.isEmpty(sessionId)) {
                return;
            }
            try (PreparedStatement ps = connection.prepareStatement("DELETE FROM assertions_tbl WHERE session_id = ?");){
                ps.setString(1, sessionId);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.warn("Unable to remove OIOSAML session '{}'", (Object)sessionId, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AssertionWrapper getAssertionFromSessionId(String sessionId) {
        try (Connection connection = this.ds.getConnection();){
            connection.setAutoCommit(true);
            AssertionWrapper assertionWrapper = null;
            try (PreparedStatement ps = connection.prepareStatement("SELECT xml_object FROM assertions_tbl WHERE session_id = ?");){
                ps.setString(1, sessionId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        assertionWrapper = new AssertionWrapper((Assertion)StringUtil.base64ToXMLObject(rs.getString(1)));
                    }
                }
            }
            if (null != assertionWrapper) {
                ps = connection.prepareStatement("UPDATE assertions_tbl SET access_time = ? WHERE session_id = ?");
                var6_8 = null;
                try {
                    ps.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now(Clock.systemDefaultZone())));
                    ps.setString(2, sessionId);
                    ps.executeUpdate();
                }
                catch (Throwable throwable) {
                    var6_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (ps != null) {
                        if (var6_8 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
            }
            AssertionWrapper assertionWrapper2 = assertionWrapper;
            return assertionWrapper2;
        }
        catch (InternalException | SQLException e) {
            log.error("Failed retrieving assertion matching sessionId", (Throwable)e);
            throw new RuntimeException("Failed retrieving assertion matching sessionId", e);
        }
    }
}

