/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session.database;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.session.SessionHandlerFactory;
import dk.gov.oio.saml.session.database.DatabaseSessionHandler;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSessionHandlerFactory
implements SessionHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(JdbcSessionHandlerFactory.class);
    private SessionHandler handler;

    @Override
    public SessionHandler getHandler() throws InternalException {
        if (null == this.handler) {
            throw new InternalException("Please call configure before getHandler");
        }
        return this.handler;
    }

    @Override
    public void close() {
        log.debug("Closing factory with handler '{}'", (Object)this.handler);
        this.handler = null;
    }

    @Override
    public void configure(Configuration config) throws InitializationException {
        final String url = config.getSessionHandlerJdbcUrl();
        final String username = config.getSessionHandlerJdbcUsername();
        final String password = config.getSessionHandlerJdbcPassword();
        String driver = config.getSessionHandlerJdbcDriverClassName();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(String.format("Unable to load driver '%s'", driver), (Throwable)e);
        }
        this.handler = new DatabaseSessionHandler(new DataSource(){

            @Override
            public Connection getConnection() throws SQLException {
                return StringUtil.isNotEmpty(username) ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
            }

            @Override
            public Connection getConnection(String usernameInput, String passwordInput) throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public PrintWriter getLogWriter() throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public void setLogWriter(PrintWriter out) throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public void setLoginTimeout(int seconds) throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public int getLoginTimeout() throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                throw new UnsupportedOperationException("Unsupported method");
            }

            @Override
            public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
                return null;
            }
        });
    }
}

