/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session.database;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.session.SessionHandlerFactory;
import dk.gov.oio.saml.session.database.DatabaseSessionHandler;
import dk.gov.oio.saml.util.InternalException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdniSessionHandlerFactory
implements SessionHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(JdniSessionHandlerFactory.class);
    private SessionHandler handler;

    @Override
    public SessionHandler getHandler() throws InternalException {
        if (null == this.handler) {
            throw new InternalException("Please call configure before getHandler");
        }
        return this.handler;
    }

    @Override
    public void close() {
        log.debug("Closing factory with handler '{}'", (Object)this.handler);
        this.handler = null;
    }

    @Override
    public void configure(Configuration config) throws InitializationException {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(config.getSessionHandlerJndiName());
            this.handler = new DatabaseSessionHandler(ds);
        }
        catch (NamingException e) {
            throw new InitializationException("Unable to create JNDI database session handler", (Throwable)e);
        }
    }
}

