/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session.inmemory;

import dk.gov.oio.saml.audit.AuditService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.AssertionWrapper;
import dk.gov.oio.saml.session.AuthnRequestWrapper;
import dk.gov.oio.saml.session.LogoutRequestWrapper;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.session.inmemory.TimeOutWrapper;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySessionHandler
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(InMemorySessionHandler.class);
    private int sessionHandlerNumTrackedSessionIds;
    private final Map<String, TimeOutWrapper<AuthnRequestWrapper>> authnRequests = new ConcurrentHashMap<String, TimeOutWrapper<AuthnRequestWrapper>>();
    private final Map<String, TimeOutWrapper<AssertionWrapper>> assertions = new ConcurrentHashMap<String, TimeOutWrapper<AssertionWrapper>>();
    private final Map<String, TimeOutWrapper<LogoutRequestWrapper>> logoutRequests = new ConcurrentHashMap<String, TimeOutWrapper<LogoutRequestWrapper>>();
    private final Map<String, TimeOutWrapper<String>> sessionIndexMap = new ConcurrentHashMap<String, TimeOutWrapper<String>>();
    private final ConcurrentSkipListSet<String> usedAssertionIds = new ConcurrentSkipListSet();

    public InMemorySessionHandler(int sessionHandlerNumTrackedSessionIds) {
        this.sessionHandlerNumTrackedSessionIds = sessionHandlerNumTrackedSessionIds;
    }

    @Override
    public void storeAuthnRequest(HttpSession session, AuthnRequestWrapper request) throws InternalException {
        if (null == request || null == request.getId()) {
            log.warn("Ignore AuthRequest with null value or missing ID");
            return;
        }
        AuthnRequestWrapper authnRequest = this.getAuthnRequest(session);
        if (null != authnRequest) {
            log.debug("AuthRequest '{}' will replace '{}'", (Object)request.getId(), (Object)authnRequest.getId());
        }
        log.debug("Store AuthRequest '{}'", (Object)request.getId());
        this.authnRequests.put(this.getSessionId(session), new TimeOutWrapper<AuthnRequestWrapper>(request));
    }

    @Override
    public void storeAssertion(HttpSession session, AssertionWrapper assertion) {
        if (null == assertion || StringUtil.isEmpty(assertion.getID())) {
            log.warn("Ignore Assertion with null value or missing ID");
            return;
        }
        if (StringUtil.isEmpty(assertion.getSessionIndex())) {
            log.info("Assertion '{}' with passive session and missing index", (Object)assertion.getID());
        }
        if (this.usedAssertionIds.contains(assertion.getID())) {
            log.warn("Assertion '{}' is being replayed", (Object)assertion.getID());
            throw new IllegalArgumentException(String.format("Assertion ID being replayed: '%s'", assertion.getID()));
        }
        this.usedAssertionIds.add(assertion.getID());
        AssertionWrapper existingAssertion = this.getAssertion(session);
        if (null != existingAssertion) {
            if (assertion.isReplayOf(existingAssertion)) {
                log.debug("Assertion '{}' is being replayed", (Object)assertion.getID(), (Object)existingAssertion.getID());
                throw new IllegalArgumentException(String.format("Assertion with id '%s' and session index '%s' is already registered", assertion.getID(), assertion.getSessionIndex()));
            }
            log.debug("Assertion '{}' will replace '{}'", (Object)assertion.getID(), (Object)existingAssertion.getID());
            this.sessionIndexMap.remove(StringUtil.defaultIfEmpty(existingAssertion.getSessionIndex(), existingAssertion.getID()));
        }
        log.debug("Store Assertion '{}'", (Object)assertion.getID());
        this.assertions.put(this.getSessionId(session), new TimeOutWrapper<AssertionWrapper>(assertion));
        this.sessionIndexMap.put(StringUtil.defaultIfEmpty(assertion.getSessionIndex(), assertion.getID()), new TimeOutWrapper<String>(this.getSessionId(session)));
    }

    @Override
    public void storeLogoutRequest(HttpSession session, LogoutRequestWrapper request) {
        if (null == request || null == request.getID()) {
            log.warn("Ignore LogoutRequest with null value or missing ID");
            return;
        }
        LogoutRequestWrapper logoutRequest = this.getLogoutRequest(session);
        if (null != logoutRequest) {
            log.debug("LogoutRequest '{}' will replace '{}'", (Object)request.getID(), (Object)logoutRequest.getID());
        }
        log.debug("Store LogoutRequest '{}'", (Object)request.getID());
        this.logoutRequests.put(this.getSessionId(session), new TimeOutWrapper<LogoutRequestWrapper>(request));
    }

    @Override
    public AuthnRequestWrapper getAuthnRequest(HttpSession session) {
        TimeOutWrapper<AuthnRequestWrapper> wrapperTimeOutWrapper = this.authnRequests.get(this.getSessionId(session));
        if (null == wrapperTimeOutWrapper || null == wrapperTimeOutWrapper.getObject()) {
            return null;
        }
        log.debug("Get AuthnRequest from the current session '{}'", (Object)this.getSessionId(session));
        wrapperTimeOutWrapper.setAccesstime();
        return wrapperTimeOutWrapper.getObject();
    }

    @Override
    public AssertionWrapper getAssertion(HttpSession session) {
        TimeOutWrapper<AssertionWrapper> wrapperTimeOutWrapper = this.assertions.get(this.getSessionId(session));
        if (null == wrapperTimeOutWrapper || null == wrapperTimeOutWrapper.getObject()) {
            return null;
        }
        log.debug("Get AssertionWrapper from the current session '{}'", (Object)this.getSessionId(session));
        wrapperTimeOutWrapper.setAccesstime();
        return wrapperTimeOutWrapper.getObject();
    }

    @Override
    public AssertionWrapper getAssertion(String sessionIndex) {
        if (null == sessionIndex || !this.sessionIndexMap.containsKey(sessionIndex)) {
            log.debug("Session index '{}' is missing", (Object)sessionIndex);
            return null;
        }
        String sessionId = this.sessionIndexMap.get(sessionIndex).getObject();
        TimeOutWrapper<AssertionWrapper> wrapperTimeOutWrapper = this.assertions.get(sessionId);
        if (null == wrapperTimeOutWrapper || null == wrapperTimeOutWrapper.getObject()) {
            return null;
        }
        log.debug("Get AssertionWrapper from the session '{}' with sessionIndex '{}'", (Object)sessionId, (Object)sessionIndex);
        wrapperTimeOutWrapper.setAccesstime();
        return wrapperTimeOutWrapper.getObject();
    }

    @Override
    public LogoutRequestWrapper getLogoutRequest(HttpSession session) {
        TimeOutWrapper<LogoutRequestWrapper> wrapperTimeOutWrapper = this.logoutRequests.get(this.getSessionId(session));
        if (null == wrapperTimeOutWrapper || null == wrapperTimeOutWrapper.getObject()) {
            return null;
        }
        log.debug("Get LogoutRequestWrapper from the current session '{}'", (Object)this.getSessionId(session));
        wrapperTimeOutWrapper.setAccesstime();
        return wrapperTimeOutWrapper.getObject();
    }

    @Override
    public String getSessionId(String sessionIndex) {
        if (StringUtil.isEmpty(sessionIndex) || !this.sessionIndexMap.containsKey(sessionIndex)) {
            return null;
        }
        return this.sessionIndexMap.get(sessionIndex).getObject();
    }

    @Override
    public void logout(HttpSession session, AssertionWrapper assertion) {
        log.debug("Logout from session '{}' and assertion '{}'", (Object)(null != session ? this.getSessionId(session) : ""), (Object)(null != assertion ? assertion.getID() : ""));
        if (null != assertion && StringUtil.isNotEmpty(assertion.getSessionIndex())) {
            this.logout(this.getSessionId(assertion.getSessionIndex()));
        }
        this.logout(this.getSessionId(session));
    }

    @Override
    public void cleanup(long maxInactiveIntervalSeconds) {
        while (!this.usedAssertionIds.isEmpty() && this.usedAssertionIds.size() > this.sessionHandlerNumTrackedSessionIds) {
            this.usedAssertionIds.remove(this.usedAssertionIds.pollFirst());
        }
        this.cleanup(this.sessionIndexMap, maxInactiveIntervalSeconds, "SessionIndexMap");
        this.cleanup(this.assertions, maxInactiveIntervalSeconds, "Assertions");
        this.cleanup(this.authnRequests, maxInactiveIntervalSeconds, "AuthnRequests");
        this.cleanup(this.logoutRequests, maxInactiveIntervalSeconds, "LogoutRequests");
    }

    private <E, T> void cleanup(Map<E, TimeOutWrapper<T>> map, long cleanupDelay, String msg) {
        log.debug("Running cleanup timer on {}", map);
        for (E key : map.keySet()) {
            TimeOutWrapper<T> tow = map.get(key);
            if (!tow.isExpired(cleanupDelay)) continue;
            log.debug("Expiring {}", tow);
            if (tow.getObject() instanceof AssertionWrapper) {
                OIOSAML3Service.getAuditService().auditLog(new AuditService.Builder().withAuthnAttribute("ACTION", "TIMEOUT").withAuthnAttribute("DESCRIPTION", "SessionDestroyed").withAuthnAttribute("SP_SESSION_ID", String.valueOf(key)).withAuthnAttribute("ASSERTION_ID", ((AssertionWrapper)tow.getObject()).getID()).withAuthnAttribute("SUBJECT_NAME_ID", ((AssertionWrapper)tow.getObject()).getSubjectNameId()));
            }
            map.remove(key);
        }
    }

    private void logout(String sessionId) {
        log.debug("Invalidate OIOSAML session '{}'", (Object)sessionId);
        if (StringUtil.isEmpty(sessionId) || !this.assertions.containsKey(sessionId)) {
            return;
        }
        TimeOutWrapper<AssertionWrapper> wrapperTimeOutWrapper = this.assertions.get(sessionId);
        this.sessionIndexMap.remove(wrapperTimeOutWrapper.getObject().getSessionIndex());
        this.assertions.remove(sessionId);
    }
}

