/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.session.inmemory;

import dk.gov.oio.saml.config.Configuration;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.session.SessionHandlerFactory;
import dk.gov.oio.saml.session.inmemory.InMemorySessionHandler;
import dk.gov.oio.saml.util.InternalException;
import org.opensaml.core.config.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySessionHandlerFactory
implements SessionHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(InMemorySessionHandlerFactory.class);
    private SessionHandler handler;

    @Override
    public SessionHandler getHandler() throws InternalException {
        if (null == this.handler) {
            throw new InternalException("Please call configure before getHandler");
        }
        return this.handler;
    }

    @Override
    public void close() {
        log.debug("Closing factory with handler '{}'", (Object)this.handler);
        this.handler = null;
    }

    @Override
    public synchronized void configure(Configuration config) throws InitializationException {
        if (null == this.handler) {
            this.handler = new InMemorySessionHandler(config.getSessionHandlerInMemoryMaxNumberOfTrackedAssertionIds());
        }
    }
}

