/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.util;

import dk.gov.oio.saml.audit.AuditService;
import dk.gov.oio.saml.service.OIOSAML3Service;
import dk.gov.oio.saml.session.SessionHandler;
import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(AuditRequestUtil.class);

    public static String getAttributeFromRequest(HttpServletRequest request, String parameter, String defaultValue) {
        if (StringUtil.isEmpty(parameter)) {
            return defaultValue;
        }
        String[] name = Objects.toString(parameter, "").split(":", 2);
        if (name.length != 2) {
            log.warn("Custom request parameter '{}' is malformed, should be '<protocol>:<attribute>'", (Object)parameter);
            return defaultValue;
        }
        switch (name[0]) {
            case "header": {
                return Objects.toString(request.getHeader(name[1]), defaultValue);
            }
            case "session": {
                return Objects.toString(request.getSession().getAttribute(name[1]), defaultValue);
            }
            case "query": {
                return AuditRequestUtil.getQueryAttributeFromRequest(request, name[1], defaultValue);
            }
            case "cookie": {
                return AuditRequestUtil.getCookieAttributeFromRequest(request, name[1], defaultValue);
            }
            case "request": {
                return AuditRequestUtil.getRequestAttributeFromRequest(request, name[1], defaultValue);
            }
        }
        log.warn("Custom parameter protocol '{}' is malformed, should be [request|query|header|cookie|session]", (Object)name[0]);
        return defaultValue;
    }

    private static String getQueryAttributeFromRequest(HttpServletRequest request, String parameter, String defaultValue) {
        CharSequence[] parameterValues = request.getParameterValues(parameter);
        return null != parameterValues && parameterValues.length > 0 ? String.join((CharSequence)",", parameterValues) : defaultValue;
    }

    private static String getCookieAttributeFromRequest(HttpServletRequest request, String parameter, String defaultValue) {
        for (Cookie cookie : request.getCookies()) {
            if (!cookie.getName().equals(parameter)) continue;
            return Objects.toString(cookie.getValue(), defaultValue);
        }
        return defaultValue;
    }

    private static String getRequestAttributeFromRequest(HttpServletRequest request, String parameter, String defaultValue) {
        switch (parameter) {
            case "remoteHost": {
                return Objects.toString(request.getRemoteHost(), defaultValue);
            }
            case "remoteAddr": {
                return Objects.toString(request.getRemoteAddr(), defaultValue);
            }
            case "remotePort": {
                return Objects.toString(String.valueOf(request.getRemotePort()), defaultValue);
            }
            case "remoteUser": {
                return Objects.toString(request.getRemoteUser(), defaultValue);
            }
            case "sessionId": {
                return Objects.toString(request.getSession().getId(), defaultValue);
            }
        }
        log.warn("Request parameter '{}' is missing, should be [remoteHost|remoteAddr|remotePort|remoteUser]", (Object)parameter);
        return defaultValue;
    }

    public static AuditService.Builder createBasicAuditBuilder(HttpServletRequest request, String action, String description) throws InternalException {
        SessionHandler handler = OIOSAML3Service.getSessionHandlerFactory().getHandler();
        return new AuditService.Builder().withAuthnAttribute("ACTION", action).withAuthnAttribute("DESCRIPTION", description).withAuthnAttribute("IP", AuditRequestUtil.getAttributeFromRequest(request, OIOSAML3Service.getConfig().getAuditRequestAttributeIP(), request.getRemoteAddr())).withAuthnAttribute("PORT", AuditRequestUtil.getAttributeFromRequest(request, OIOSAML3Service.getConfig().getAuditRequestAttributePort(), String.valueOf(request.getRemotePort()))).withAuthnAttribute("SESSION_ID", AuditRequestUtil.getAttributeFromRequest(request, OIOSAML3Service.getConfig().getAuditRequestAttributeSessionId(), request.getSession().getId())).withAuthnAttribute("SP_SESSION_ID", handler.getSessionId(request.getSession())).withAuthnAttribute("REQUESTED_SESSION_ID", request.getRequestedSessionId()).withAuthnAttribute("USER", AuditRequestUtil.getAttributeFromRequest(request, OIOSAML3Service.getConfig().getAuditRequestAttributeServiceProviderUserId(), request.getRemoteUser())).withAuthnAttribute("USER-AGENT", AuditRequestUtil.getAttributeFromRequest(request, "header:User-Agent", AuditRequestUtil.getAttributeFromRequest(request, "header:Sec-Ch-Ua", "None")));
    }
}

