/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.util;

import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);

    public static File getResourceAsFile(String resourceName) throws InternalException {
        if (StringUtil.isEmpty(resourceName)) {
            throw new InternalException(String.format("Unable to load resource file '%s'", resourceName));
        }
        try {
            File file;
            URL url = ResourceUtil.getClassLoader().getResource(resourceName);
            if (url != null && "jar".equals(url.getProtocol())) {
                try (InputStream inputStream = ResourceUtil.getResourceAsStream(resourceName);){
                    Path path = Files.createTempFile(resourceName, "tmp", new FileAttribute[0]);
                    Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    file = path.toFile();
                }
            } else {
                file = url != null ? new File(url.toURI()) : new File(resourceName);
            }
            if (!file.exists()) {
                throw new InternalException(String.format("Unable to load resource file '%s'", resourceName));
            }
            return file;
        }
        catch (IOException | URISyntaxException e) {
            throw new InternalException(String.format("Unable to load resource file '%s'", resourceName), e);
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws InternalException {
        if (StringUtil.isEmpty(resourceName)) {
            throw new InternalException(String.format("Unable to load resource '%s'", resourceName));
        }
        InputStream inputStream = ResourceUtil.getClassLoader().getResourceAsStream(resourceName);
        if (null == inputStream) {
            try {
                return new FileInputStream(ResourceUtil.getResourceAsFile(resourceName));
            }
            catch (FileNotFoundException e) {
                throw new InternalException(String.format("Unable to load resource '%s'", resourceName), e);
            }
        }
        return inputStream;
    }

    public static Map<String, String> getConfig(String configurationFile) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (StringUtil.isNotEmpty(configurationFile)) {
            try (InputStream is = ResourceUtil.getResourceAsStream(configurationFile);){
                Properties p = new Properties();
                p.load(is);
                Enumeration<?> enums = p.propertyNames();
                while (enums.hasMoreElements()) {
                    String key = (String)enums.nextElement();
                    String value = p.getProperty(key);
                    configMap.put(key, value);
                }
            }
            catch (Exception ex) {
                log.warn("Failed to load external configuration file: '{}'", (Object)configurationFile, (Object)ex);
            }
        }
        return configMap;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Class.class.getClassLoader();
        }
        return classLoader;
    }
}

