/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlHelper {
    private static final Logger log = LoggerFactory.getLogger(SamlHelper.class);

    public static <T> T build(Class<T> clazz) {
        XMLObject object = null;
        try {
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            QName defaultElementName = (QName)clazz.getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
            object = builderFactory.getBuilder(defaultElementName).buildObject(defaultElementName);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Could not create SAML object");
        }
        return (T)object;
    }

    public static Map<String, String> extractAttributeValues(AttributeStatement attributeStatement) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Attribute attribute : attributeStatement.getAttributes()) {
            String name = attribute.getName();
            String value = SamlHelper.extractAttributeValueValue(attribute);
            if ("dk:gov:saml:attribute:CprNumberIdentifier".equals(name) || name == null || value == null || name.isEmpty() || value.isEmpty()) continue;
            result.put(name, value);
        }
        return result;
    }

    public static Element marshallObject(XMLObject object) throws MarshallingException {
        if (object.getDOM() == null) {
            Marshaller m = SamlHelper.getMarshaller(object);
            if (m == null) {
                throw new IllegalArgumentException("No unmarshaller for " + object);
            }
            return m.marshall(object);
        }
        return object.getDOM();
    }

    public static XMLObject unmarshallObject(Element marshalledObject) throws UnmarshallingException {
        Unmarshaller unmarshaller = SamlHelper.getUnmarshaller(marshalledObject);
        if (unmarshaller == null) {
            throw new IllegalArgumentException("No unmarshaller for " + marshalledObject);
        }
        return unmarshaller.unmarshall(marshalledObject);
    }

    private static String extractAttributeValueValue(Attribute attribute) {
        for (int i = 0; i < attribute.getAttributeValues().size(); ++i) {
            if (attribute.getAttributeValues().get(i) instanceof XSString) {
                XSString str = (XSString)attribute.getAttributeValues().get(i);
                if (!"AttributeValue".equals(str.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(str.getElementQName().getNamespaceURI())) continue;
                return str.getValue();
            }
            XSAny ep = (XSAny)attribute.getAttributeValues().get(i);
            if (!"AttributeValue".equals(ep.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(ep.getElementQName().getNamespaceURI())) continue;
            if (ep.getUnknownXMLObjects().size() > 0) {
                StringBuilder res = new StringBuilder();
                for (XMLObject obj : ep.getUnknownXMLObjects()) {
                    try {
                        res.append(SerializeSupport.nodeToString((Node)SamlHelper.marshallObject(obj)));
                    }
                    catch (MarshallingException ex) {
                        log.debug("Failed to marshall attribute - ignoring attribute", (Throwable)ex);
                    }
                }
                return res.toString();
            }
            return ep.getTextContent();
        }
        return null;
    }

    private static XMLObjectProviderRegistry getProviderRegistry() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        if (registry == null) {
            throw new XMLRuntimeException("XMLObjectProviderRegistry was not available from the ConfigurationService");
        }
        return registry;
    }

    private static Marshaller getMarshaller(XMLObject xmlObject) {
        return SamlHelper.getProviderRegistry().getMarshallerFactory().getMarshaller(xmlObject);
    }

    private static Unmarshaller getUnmarshaller(Element marshalledObject) {
        return SamlHelper.getProviderRegistry().getUnmarshallerFactory().getUnmarshaller(marshalledObject);
    }
}

