/*
 * Decompiled with CFR 0.152.
 */
package dk.gov.oio.saml.util;

import dk.gov.oio.saml.util.InternalException;
import dk.gov.oio.saml.util.SamlHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.w3c.dom.Element;

public class StringUtil {
    public static String getUrl(HttpServletRequest request, String page) {
        String url = StringUtil.isNotEmpty(request.getContextPath()) ? request.getContextPath() : "/";
        int slashCount = url.endsWith("/") ? 1 : 0;
        switch (slashCount += page != null && page.startsWith("/") ? 1 : 0) {
            case 0: {
                url = url + "/" + (page != null ? page : "");
                break;
            }
            case 1: {
                url = url + (page != null ? page : "");
                break;
            }
            case 2: {
                url = url + (page != null ? page.substring(1) : "");
            }
        }
        return url;
    }

    public static String elementToString(Element element) {
        try {
            DOMSource source = new DOMSource(element);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, new StreamResult(buffer));
            return buffer.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String xmlObjectToBase64(XMLObject xmlObject) throws InternalException {
        try {
            Element element = SamlHelper.marshallObject(xmlObject);
            DOMSource source = new DOMSource(element);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}strip-spaces", "*");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, new StreamResult(buffer));
            return Base64.getEncoder().encodeToString(buffer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (TransformerException | MarshallingException e) {
            throw new InternalException("Unable to parse XML object to string", (Exception)e);
        }
    }

    public static XMLObject base64ToXMLObject(String base64) throws InternalException {
        try {
            byte[] decodedInput = Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
            return XMLObjectSupport.unmarshallFromInputStream((ParserPool)XMLObjectProviderRegistrySupport.getParserPool(), (InputStream)new ByteArrayInputStream(decodedInput));
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new InternalException("Unable to parse input to XML object", (Exception)e);
        }
    }

    public static String jsonEscape(String value) {
        StringBuilder sb = new StringBuilder();
        if (null == value) {
            return "";
        }
        block8: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\"': 
                case '\\': {
                    sb.append("\\").append(ch);
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                default: {
                    if (ch <= '\u001f' | ch == '\u2028' | ch == '\u2029') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block8;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static boolean isEmpty(String input) {
        return null == input || input.trim().isEmpty();
    }

    public static boolean isNotEmpty(String input) {
        return !StringUtil.isEmpty(input);
    }

    public static String defaultIfEmpty(String input, String defaultString) {
        if (null == input || input.trim().isEmpty()) {
            return defaultString;
        }
        return input;
    }

    public static String map2json(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> String.format("\"%s\":\"%s\"", entry.getKey(), StringUtil.jsonEscape((String)entry.getValue()))).collect(Collectors.joining(",", "{", "}"));
    }
}

