/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.TimeUnit;

public class DurationFormatter
implements Serializable {
    private static final long serialVersionUID = -1806478460924436710L;
    private static final char DECIMAL_SEPERATOR = new DecimalFormatSymbols().getDecimalSeparator();
    private static final long MC_S = 1000L;
    private static final long MS = 1000000L;
    private static final long S = 1000000000L;
    private static final long M = 60000000000L;
    private static final long H = 3600000000000L;
    private static final long D = 86400000000000L;
    private static final String[] NAME = new String[]{"nanosecond", "microsecond", "millisecond", "second", "minute", "hour", "day"};
    private static final String[] NAMES = new String[]{"nanoseconds", "microseconds", "milliseconds", "seconds", "minutes", "hours", "days"};
    static final String[] SI_SYMBOL = new String[]{"ns", "us", "ms", "s", "min", "h", "d"};
    public static final DurationFormatter DEFAULT = new DefaultFormatter();
    public static final DurationFormatter UPTIME = new UptimeFormatter();

    protected String doFormat(int nano) {
        return this.doFormat(0, nano);
    }

    protected String doFormat(int micros, int nano) {
        return this.doFormat(0, micros, nano);
    }

    protected String doFormat(int millies, int micros, int nano) {
        return this.doFormat(0, millies, micros, nano);
    }

    protected String doFormat(int seconds, int millies, int micros, int nano) {
        return this.doFormat(0, seconds, millies, micros, nano);
    }

    protected String doFormat(int minutes, int seconds, int millies, int micros, int nano) {
        return this.doFormat(0, minutes, seconds, millies, micros, nano);
    }

    protected String doFormat(int hours, int minutes, int seconds, int millies, int micros, int nano) {
        return this.doFormat(0, hours, minutes, seconds, millies, micros, nano);
    }

    protected String doFormat(int days, int hours, int minutes, int seconds, int millies, int micros, int nano) {
        return days + " day(s), " + this.format00(hours) + ":" + this.format00(minutes) + ":" + this.format00(seconds + (millies >= 500 ? 1 : 0)) + " hours";
    }

    public String format(long time, TimeUnit unit) {
        return this.formatNanos(unit.toNanos(time));
    }

    public String formatMillies(long millies) {
        return this.formatNanos(millies * 1000000L);
    }

    public String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return this.doFormat((int)nanos);
        }
        if (nanos < 1000000L) {
            return this.doFormat((int)(nanos / 1000L), (int)(nanos % 1000L));
        }
        if (nanos < 1000000000L) {
            return this.doFormat((int)(nanos / 1000000L), (int)(nanos / 1000L % 1000L), (int)(nanos % 1000L));
        }
        if (nanos < 60000000000L) {
            return this.doFormat((int)(nanos / 1000000000L), (int)(nanos / 1000000L % 1000L), (int)(nanos / 1000L % 1000L), (int)(nanos % 1000L));
        }
        if (nanos < 3600000000000L) {
            return this.doFormat((int)(nanos / 60000000000L), (int)(nanos / 1000000000L % 60L), (int)(nanos / 1000000L % 1000L), (int)(nanos / 1000L % 1000L), (int)(nanos % 1000L));
        }
        if (nanos < 86400000000000L) {
            return this.doFormat((int)(nanos / 3600000000000L), (int)(nanos / 60000000000L % 60L), (int)(nanos / 1000000000L % 60L), (int)(nanos / 1000000L % 1000L), (int)(nanos / 1000L % 1000L), (int)(nanos % 1000L));
        }
        return this.doFormat((int)(nanos / 86400000000000L), (int)(nanos / 3600000000000L % 24L), (int)(nanos / 60000000000L % 60L), (int)(nanos / 1000000000L % 60L), (int)(nanos / 1000000L % 1000L), (int)(nanos / 1000L % 1000L), (int)(nanos % 1000L));
    }

    protected String getName(long value, TimeUnit unit) {
        return value == 1L ? NAME[unit.ordinal()] : NAMES[unit.ordinal()];
    }

    protected String getSymbol(TimeUnit unit) {
        return SI_SYMBOL[unit.ordinal()];
    }

    protected String format_000(int value, int decimal) {
        return "" + value + DECIMAL_SEPERATOR + this.format000(decimal);
    }

    private String format00(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    private String format000(int value) {
        if (value < 10) {
            return "00" + value;
        }
        if (value < 100) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    static class UptimeFormatter
    extends DurationFormatter {
        private static final long serialVersionUID = 3440524099536856811L;

        UptimeFormatter() {
        }
    }

    static class DefaultFormatter
    extends UptimeFormatter {
        private static final long serialVersionUID = -7573098942957592504L;

        DefaultFormatter() {
        }

        @Override
        protected String doFormat(int nano) {
            return nano + " " + SI_SYMBOL[0];
        }

        @Override
        protected String doFormat(int micros, int nano) {
            return this.format_000(micros, nano) + " " + SI_SYMBOL[1];
        }

        @Override
        protected String doFormat(int millies, int micros, int nano) {
            return this.format_000(millies, micros) + " " + SI_SYMBOL[2];
        }

        @Override
        protected String doFormat(int seconds, int millies, int micros, int nano) {
            return this.format_000(seconds, millies) + " s";
        }
    }
}

