/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import dk.dma.commons.util.Iterators;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class Iterables {
    public static <T> Iterable<T> counting(final Iterable<T> iterable, final AtomicLong counter) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(counter);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.counting(iterable.iterator(), counter);
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> unfiltered, final Predicate<? super T> predicate) {
        Objects.requireNonNull(unfiltered);
        Objects.requireNonNull(predicate);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(unfiltered.iterator(), predicate);
            }
        };
    }
}

