/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JSONObject {
    public static final String UNIX_LINE_SEPARATOR = "\n";
    private final List<Map.Entry<String, Object>> elements = new ArrayList<Map.Entry<String, Object>>();

    private void add(String name, Object o) {
        this.elements.add(new AbstractMap.SimpleImmutableEntry<String, Object>(Objects.requireNonNull(name), o));
    }

    public JSONObject addElement(String name, Object value) {
        this.add(name, value);
        return this;
    }

    public JSONObject addList(String name, Object ... values) {
        this.add(name, Arrays.asList(values));
        return this;
    }

    private void addValue(StringBuilder sb, Object stringOrNumber) {
        if (stringOrNumber instanceof Number) {
            sb.append(stringOrNumber);
        } else {
            sb.append('\"').append(stringOrNumber).append("\"");
        }
    }

    public JSONObject newChild(String name) {
        JSONObject o2 = new JSONObject();
        this.add(name, o2);
        return o2;
    }

    public static JSONObject single(String name, Object value) {
        return new JSONObject().addElement(name, value);
    }

    public static JSONObject single(String name, Object value, String name1, Object value1) {
        return new JSONObject().addElement(name, value).addElement(name1, value1);
    }

    public static JSONObject single(String name, Object value, String name1, Object value1, String name2, Object value2) {
        return new JSONObject().addElement(name, value).addElement(name1, value1).addElement(name2, value2);
    }

    public static JSONObject singleList(String name, Object ... value) {
        return new JSONObject().addElement(name, Arrays.asList(value));
    }

    public static void main(String[] args) {
        JSONObject.singleList("sources", "AisD", "Helcom").toString();
        System.out.println(JSONObject.single("sources", "AisD", "23234", 1322));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(UNIX_LINE_SEPARATOR);
        this.toString(sb, 1);
        sb.append("}\n");
        return sb.toString();
    }

    private void toString(StringBuilder sb, int indent) {
        for (Map.Entry<String, Object> e : this.elements) {
            JSONObject.spaces(sb, indent * 2);
            sb.append('\"').append(e.getKey()).append("\": ");
            Object o = e.getValue();
            if (o instanceof List) {
                List l = (List)o;
                sb.append("[");
                for (int i = 0; i < l.size(); ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    this.addValue(sb, l.get(i));
                }
                sb.append("]");
            } else if (o instanceof JSONObject) {
                JSONObject jo = (JSONObject)o;
                jo.toString(sb, indent + 1);
            } else {
                this.addValue(sb, o);
            }
            sb.append(UNIX_LINE_SEPARATOR);
        }
    }

    public static StringBuilder spaces(StringBuilder sb, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb;
    }
}

