/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.concurrent;

import dk.dma.enav.util.function.EConsumer;
import java.util.Objects;
import java.util.concurrent.CountedCompleter;
import java.util.function.Consumer;

public class ForkJoinUtil {
    public static <E> void forEach(E[] array, Consumer<E> consumer) {
        Objects.requireNonNull(array, "array is null");
        Objects.requireNonNull(consumer, "consumer is null");
        new ForEach<E>(null, consumer, array, 0, array.length).invoke();
    }

    public static <E> void forEach(E[] array, EConsumer<E> consumer) throws Exception {
        Objects.requireNonNull(array, "array is null");
        Objects.requireNonNull(consumer, "consumer is null");
        try {
            new ForEachE<E>(null, consumer, array, 0, array.length).invoke();
        }
        catch (InnerRuntimeException i) {
            throw (Exception)i.getCause();
        }
    }

    static class InnerRuntimeException
    extends RuntimeException {
        InnerRuntimeException(Exception e) {
            super(e);
        }
    }

    static class ForEachE<E>
    extends CountedCompleter<Void> {
        private final E[] array;
        private final int hi;
        private final int lo;
        private final EConsumer<E> op;

        ForEachE(CountedCompleter<?> p, EConsumer<E> op, E[] array, int lo, int hi) {
            super(p);
            this.array = array;
            this.op = op;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public void compute() {
            int l = this.lo;
            int h = this.hi;
            while (h - l >= 2) {
                int mid = l + h >>> 1;
                this.addToPendingCount(1);
                ForEachE<E> fe = new ForEachE<E>(this, this.op, this.array, mid, h);
                fe.fork();
                h = mid;
            }
            if (h > l) {
                try {
                    this.op.accept(this.array[l]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.completeExceptionally(new InnerRuntimeException(e));
                }
            }
            this.propagateCompletion();
        }
    }

    static class ForEach<E>
    extends CountedCompleter<Void> {
        private final E[] array;
        private final int hi;
        private final int lo;
        private final Consumer<E> op;

        ForEach(CountedCompleter<?> p, Consumer<E> op, E[] array, int lo, int hi) {
            super(p);
            this.array = array;
            this.op = op;
            this.lo = lo;
            this.hi = hi;
        }

        @Override
        public void compute() {
            int l = this.lo;
            int h = this.hi;
            while (h - l >= 2) {
                int mid = l + h >>> 1;
                this.addToPendingCount(1);
                ForEach<E> fe = new ForEach<E>(this, this.op, this.array, mid, h);
                fe.fork();
                h = mid;
            }
            if (h > l) {
                this.op.accept(this.array[l]);
            }
            this.propagateCompletion();
        }
    }
}

