/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.filtering;

import dk.dma.commons.management.ManagedAttribute;
import dk.dma.commons.management.ManagedOperation;
import dk.dma.commons.util.filtering.Cleaner;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class DownSamplingFilter<T>
implements Predicate<T> {
    final AtomicLong accepted = new AtomicLong();
    final ConcurrentHashMap<T, Long> cache = new ConcurrentHashMap();
    final AtomicLong rejected = new AtomicLong();
    volatile long samplingRateNanos;

    public DownSamplingFilter() {
        this(1L, TimeUnit.MINUTES);
    }

    public DownSamplingFilter(long rate, TimeUnit unit) {
        this.setSamplingRate(rate, unit);
        Cleaner.add(new Runnable(){

            @Override
            public void run() {
                long toOld = System.nanoTime() - DownSamplingFilter.this.samplingRateNanos * 2L;
                Iterator<Long> i = DownSamplingFilter.this.cache.values().iterator();
                while (i.hasNext()) {
                    if (i.next() > toOld) continue;
                    i.remove();
                }
            }
        });
    }

    @ManagedOperation
    public void clear() {
        this.cache.clear();
    }

    @ManagedAttribute
    public long getAcceptanceCount() {
        return this.accepted.get();
    }

    @ManagedAttribute
    public int getCacheSize() {
        return this.cache.size();
    }

    @ManagedAttribute
    public long getTotalCount() {
        return this.getAcceptanceCount() + this.getRejectionCount();
    }

    @ManagedAttribute
    public long getRejectionCount() {
        return this.rejected.get();
    }

    public long getSamplingRate(TimeUnit unit) {
        return unit.convert(this.samplingRateNanos, TimeUnit.NANOSECONDS);
    }

    public DownSamplingFilter<T> setSamplingRate(long rate, TimeUnit unit) {
        if (rate < 0L) {
            throw new IllegalArgumentException("Sampling rate must be non-negative, was " + rate);
        }
        this.samplingRateNanos = unit.toNanos(rate);
        return this;
    }

    @Override
    public boolean test(T element) {
        Objects.requireNonNull(element);
        long samplingRateNanos = this.samplingRateNanos;
        if (samplingRateNanos == 0L) {
            return true;
        }
        while (true) {
            Long lastTimestamp = this.cache.get(element);
            Long now = new Long(System.nanoTime());
            if (lastTimestamp == null) {
                if (this.cache.putIfAbsent(element, now) != null) continue;
                this.accepted.incrementAndGet();
                return true;
            }
            if (now - lastTimestamp <= samplingRateNanos) {
                this.rejected.incrementAndGet();
                return false;
            }
            if (this.cache.replace(element, lastTimestamp, now) && this.cache.get(element) == now) break;
        }
        this.accepted.incrementAndGet();
        return true;
    }
}

