/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class CountingInputStream
extends FilterInputStream {
    private final AtomicLong counter;

    public CountingInputStream(InputStream in) {
        this(in, new AtomicLong());
    }

    public CountingInputStream(InputStream in, AtomicLong counter) {
        super(in);
        this.counter = Objects.requireNonNull(counter);
    }

    public long getCount() {
        return this.counter.get();
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            this.counter.incrementAndGet();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.counter.addAndGet(result);
        }
        return result;
    }
}

