/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class CountingOutputStream
extends FilterOutputStream {
    private final AtomicLong counter;

    public CountingOutputStream(OutputStream out) {
        this(out, new AtomicLong());
    }

    public CountingOutputStream(OutputStream out, AtomicLong counter) {
        super(out);
        this.counter = Objects.requireNonNull(counter);
    }

    public long getCount() {
        return this.counter.get();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.counter.addAndGet(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.counter.incrementAndGet();
    }
}

