/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class Country
implements Serializable,
Comparable<Country> {
    private static final long serialVersionUID = 1L;
    private static final String LOCATION = Country.class.getPackage().getName().replace(".", "/") + "/country.properties";
    static final HashMap<Integer, Country> MID_COUNTRY_MAP = new HashMap();
    static final HashMap<String, Country> THREE_LETTER_MAP = new HashMap();
    static final HashMap<String, Country> TWO_LETTER_MAP = new HashMap();
    private final HashSet<Integer> mids = new HashSet();
    protected final String name;
    protected final String number;
    protected final String threeLetter;
    protected final String twoLetter;

    private Country(String name, String twoLetter, String threeLetter, String number) {
        this.name = name;
        this.twoLetter = twoLetter;
        this.threeLetter = threeLetter;
        this.number = number;
    }

    void addMid(int mid) {
        this.mids.add(mid);
    }

    public boolean equals(Object obj) {
        return this.threeLetter.equals(((Country)obj).getThreeLetter());
    }

    public HashSet<Integer> getMids() {
        return this.mids;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getThreeLetter() {
        return this.threeLetter;
    }

    public String getTwoLetter() {
        return this.twoLetter;
    }

    public int hashCode() {
        return this.twoLetter.hashCode();
    }

    public boolean matchMid(int mid) {
        return this.mids.contains(mid);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[name=");
        builder.append(this.name);
        builder.append(", number=");
        builder.append(this.number);
        builder.append(", threeLetter=");
        builder.append(this.threeLetter);
        builder.append(", twoLetter=");
        builder.append(this.twoLetter);
        builder.append(", mids=");
        builder.append(this.mids);
        builder.append("]");
        return builder.toString();
    }

    public static Country getByCode(String code) {
        if (code.length() == 2) {
            return TWO_LETTER_MAP.get(code);
        }
        return THREE_LETTER_MAP.get(code);
    }

    public static Country getByMid(int mid) {
        Country country = MID_COUNTRY_MAP.get(mid);
        if (country == null) {
            // empty if block
        }
        return country;
    }

    public static Country getCountryForMmsi(Integer mmsi) {
        String str = Integer.toString(mmsi);
        if (str.length() == 9) {
            str = str.substring(0, 3);
            return Country.getByMid(Integer.parseInt(str));
        }
        return null;
    }

    public static Map<Integer, Country> getMidMap() {
        return Collections.unmodifiableMap(MID_COUNTRY_MAP);
    }

    public static List<Country> findAllByCode(String ... countries) {
        ArrayList<Country> c = new ArrayList<Country>();
        for (String s : countries) {
            Country co = Country.getByCode(s);
            if (co == null) {
                throw new IllegalArgumentException("Unknown country: " + s);
            }
            c.add(co);
        }
        return c;
    }

    @Override
    public int compareTo(Country o) {
        return this.threeLetter.compareTo(o.threeLetter);
    }

    static {
        Properties props = new Properties();
        URL url = ClassLoader.getSystemResource(LOCATION);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(LOCATION);
        }
        if (url == null) {
            throw new Error("Could not locate " + LOCATION + " on classpath");
        }
        try {
            props.load(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new Error("Failed to load country.properties: " + e.getMessage());
        }
        for (Object key : props.keySet()) {
            String a2 = (String)key;
            String val = props.getProperty(a2);
            String[] elems = val.split("\\|");
            Country country = new Country(elems[0], a2, elems[1], elems[2]);
            if (elems.length > 3) {
                String[] strMids;
                for (String strMid : strMids = elems[3].split(",")) {
                    Integer mid = Integer.parseInt(strMid);
                    country.addMid(mid);
                    MID_COUNTRY_MAP.put(mid, country);
                }
            }
            TWO_LETTER_MAP.put(country.getTwoLetter(), country);
            THREE_LETTER_MAP.put(country.getThreeLetter(), country);
        }
    }
}

